/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.state;

import com.hedera.node.app.service.contract.impl.state.AbstractEvmEntityAccount;
import com.hedera.node.app.service.contract.impl.state.EvmFrameState;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Set;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.code.CodeFactory;

public class ScheduleEvmAccount
extends AbstractEvmEntityAccount {
    private static final Set<Integer> SCHEDULE_PROXY_FUNCTION_SELECTOR = Set.of(Integer.valueOf(-971117947), Integer.valueOf(114382985), Integer.valueOf(-2001791773));

    public ScheduleEvmAccount(@NonNull Address address, @NonNull EvmFrameState state) {
        super(address, state);
    }

    @Override
    public boolean isScheduleTxnFacade() {
        return true;
    }

    public Bytes getCode() {
        return this.state.getScheduleRedirectCode(this.address);
    }

    @Override
    @NonNull
    public Code getEvmCode(@NonNull Bytes functionSelector, @NonNull CodeFactory codeFactory) {
        int selector;
        int n = selector = functionSelector.size() >= 4 ? functionSelector.getInt(0) : 0;
        if (!SCHEDULE_PROXY_FUNCTION_SELECTOR.contains(selector)) {
            return codeFactory.createCode(Bytes.EMPTY, false);
        }
        return codeFactory.createCode(this.getCode(), false);
    }

    public Hash getCodeHash() {
        return this.state.getScheduleRedirectCodeHash(this.address);
    }
}

