/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.state.hooks;

import com.hedera.hapi.node.state.hooks.EvmHookState;
import com.hedera.node.app.service.contract.impl.exec.scope.HederaNativeOperations;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.HtsSystemContract;
import com.hedera.node.app.service.contract.impl.state.ContractStateStore;
import com.hedera.node.app.service.contract.impl.state.DispatchingEvmFrameState;
import com.hedera.node.app.service.contract.impl.state.hooks.ProxyEvmHook;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.account.MutableAccount;
import org.hyperledger.besu.evm.code.CodeFactory;

public class HookEvmFrameState
extends DispatchingEvmFrameState {
    private final EvmHookState hook;
    private final CodeFactory codeFactory;

    public HookEvmFrameState(@NonNull HederaNativeOperations nativeOperations, @NonNull ContractStateStore contractStateStore, @NonNull CodeFactory codeFactory, @NonNull EvmHookState hook) {
        super(nativeOperations, contractStateStore, codeFactory);
        this.hook = Objects.requireNonNull(hook);
        this.codeFactory = Objects.requireNonNull(codeFactory);
    }

    @Override
    @Nullable
    public MutableAccount getMutableAccount(@NonNull Address address) {
        if (address.equals((Object)HtsSystemContract.HTS_HOOKS_16D_CONTRACT_ADDRESS)) {
            return new ProxyEvmHook(this, this.hook, this.codeFactory);
        }
        return super.getMutableAccount(address);
    }

    @Override
    @Nullable
    public Address getAddress(long number) {
        if (number == HtsSystemContract.HTS_HOOKS_16D_CONTRACT_ID.contractNumOrThrow()) {
            return HtsSystemContract.HTS_HOOKS_16D_CONTRACT_ADDRESS;
        }
        return super.getAddress(number);
    }
}

