/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.utils;

import com.google.common.primitives.Longs;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.contract.ContractFunctionResult;
import com.hedera.hapi.node.contract.EvmTransactionResult;
import com.hedera.hapi.node.contract.InternalCallContext;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.frame.MessageFrame;

public final class SystemContractUtils {
    public static final String HTS_PRECOMPILED_CONTRACT_ADDRESS = "0x167";
    public static final ContractID HTS_PRECOMPILE_MIRROR_ID = SystemContractUtils.contractIdFromEvmAddress(Address.fromHexString((String)"0x167").toArrayUnsafe());

    private SystemContractUtils() {
        throw new UnsupportedOperationException("Utility Class");
    }

    @NonNull
    public static ContractFunctionResult successResultOfZeroValueTraceable(long gasUsed, Bytes result, long gas, @NonNull Bytes inputData, @NonNull AccountID senderId) {
        return ContractFunctionResult.newBuilder().gasUsed(gasUsed).gas(gas).contractCallResult(ConversionUtils.tuweniToPbjBytes(result)).functionParameters(ConversionUtils.tuweniToPbjBytes(inputData)).senderId(senderId).contractID(HTS_PRECOMPILE_MIRROR_ID).build();
    }

    @NonNull
    public static EvmTransactionResult txSuccessResultOfZeroValueTraceable(long gasUsed, Bytes result, long gas, @NonNull Bytes inputData, @NonNull AccountID senderId) {
        return EvmTransactionResult.newBuilder().internalCallContext(InternalCallContext.newBuilder().gas(gas).callData(ConversionUtils.tuweniToPbjBytes(inputData))).gasUsed(gasUsed).resultData(ConversionUtils.tuweniToPbjBytes(result)).senderId(senderId).contractId(HTS_PRECOMPILE_MIRROR_ID).build();
    }

    @NonNull
    public static ContractFunctionResult successResultOf(@NonNull AccountID senderId, @NonNull FullResult fullResult, @NonNull MessageFrame frame, boolean includeTraceabilityFields) {
        Objects.requireNonNull(senderId);
        Objects.requireNonNull(fullResult);
        Objects.requireNonNull(frame);
        ContractFunctionResult.Builder builder = ContractFunctionResult.newBuilder().gasUsed(fullResult.gasRequirement()).contractCallResult(ConversionUtils.tuweniToPbjBytes(fullResult.result().getOutput())).senderId(senderId).contractID(HTS_PRECOMPILE_MIRROR_ID);
        if (includeTraceabilityFields) {
            builder.gas(frame.getRemainingGas()).amount(frame.getValue().toLong()).functionParameters(ConversionUtils.tuweniToPbjBytes(frame.getInputData()));
        }
        return builder.build();
    }

    @NonNull
    public static EvmTransactionResult txSuccessResultOf(@NonNull AccountID senderId, @NonNull FullResult fullResult, @NonNull MessageFrame frame, boolean includeTraceabilityFields) {
        Objects.requireNonNull(senderId);
        Objects.requireNonNull(fullResult);
        Objects.requireNonNull(frame);
        EvmTransactionResult.Builder builder = EvmTransactionResult.newBuilder().gasUsed(fullResult.gasRequirement()).resultData(ConversionUtils.tuweniToPbjBytes(fullResult.result().getOutput())).senderId(senderId).contractId(HTS_PRECOMPILE_MIRROR_ID);
        if (includeTraceabilityFields) {
            builder.internalCallContext(InternalCallContext.newBuilder().gas(frame.getRemainingGas()).value(frame.getValue().toLong()).callData(ConversionUtils.tuweniToPbjBytes(frame.getInputData())));
        }
        return builder.build();
    }

    @NonNull
    public static ContractFunctionResult contractFunctionResultFailedFor(@NonNull AccountID senderId, @NonNull FullResult fullResult, String errorMsg, ContractID contractID) {
        return SystemContractUtils.contractFunctionResultFailedFor(senderId, fullResult.result().getOutput(), fullResult.gasRequirement(), errorMsg, contractID);
    }

    @NonNull
    public static ContractFunctionResult contractFunctionResultFailedFor(@NonNull AccountID senderId, @NonNull Bytes result, long gasRequirement, String errorMsg, ContractID contractID) {
        return ContractFunctionResult.newBuilder().gasUsed(gasRequirement).contractCallResult(ConversionUtils.tuweniToPbjBytes(result)).senderId(senderId).errorMessage(errorMsg).contractID(contractID).build();
    }

    @NonNull
    public static EvmTransactionResult txResultFailedFor(@NonNull AccountID senderId, @NonNull Bytes result, long gasRequirement, String errorMsg, ContractID contractID) {
        return EvmTransactionResult.newBuilder().gasUsed(gasRequirement).resultData(ConversionUtils.tuweniToPbjBytes(result)).senderId(senderId).errorMessage(errorMsg).contractId(contractID).build();
    }

    private static ContractID contractIdFromEvmAddress(byte[] bytes) {
        return ContractID.newBuilder().contractNum(Longs.fromByteArray((byte[])Arrays.copyOfRange(bytes, 12, 20))).build();
    }

    public static com.hedera.pbj.runtime.io.buffer.Bytes messageFromScheduleId(ScheduleID scheduleId) {
        ByteBuffer buffer = ByteBuffer.allocate(24);
        buffer.putLong(scheduleId.shardNum());
        buffer.putLong(scheduleId.realmNum());
        buffer.putLong(scheduleId.scheduleNum());
        return com.hedera.pbj.runtime.io.buffer.Bytes.wrap((byte[])buffer.array());
    }

    public static enum ResultStatus {
        IS_SUCCESS,
        IS_ERROR;

    }
}

