/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.api;

import io.helidon.webclient.api.DnsAddressLookup;
import io.helidon.webclient.spi.DnsResolver;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class DefaultDnsResolver
implements DnsResolver {
    private DefaultDnsResolver() {
    }

    public static DefaultDnsResolver create() {
        return new DefaultDnsResolver();
    }

    @Override
    public boolean useDefaultJavaResolver() {
        return true;
    }

    @Override
    public InetAddress resolveAddress(String hostname, DnsAddressLookup dnsAddressLookup) {
        try {
            InetAddress[] addresses = InetAddress.getAllByName(hostname);
            addresses = dnsAddressLookup.filter(addresses);
            if (addresses.length > 0) {
                return addresses[0];
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Failed to get address for host " + hostname);
    }
}

