/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.common.types.TypeName;
import io.helidon.service.registry.ServiceRegistry;
import io.helidon.service.registry.Services;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class RegistryBuilderSupport {
    private RegistryBuilderSupport() {
    }

    public static <T> List<T> serviceList(Optional<ServiceRegistry> registry, TypeName contract, boolean useRegistry) {
        if (!useRegistry) {
            return List.of();
        }
        ArrayList result = new ArrayList();
        if (registry.isPresent()) {
            result.addAll(registry.get().all(contract));
        } else {
            result.addAll(Services.all(contract));
        }
        return List.copyOf(result);
    }

    public static <T> Set<T> serviceSet(Optional<ServiceRegistry> registry, TypeName contract, boolean useRegistry) {
        if (!useRegistry) {
            return Set.of();
        }
        HashSet result = new HashSet();
        if (registry.isPresent()) {
            result.addAll(registry.get().all(contract));
        } else {
            result.addAll(Services.all(contract));
        }
        return Set.copyOf(result);
    }

    public static <T> Optional<T> service(Optional<ServiceRegistry> registry, TypeName contract, Optional<T> existingValue, boolean useRegistry) {
        if (existingValue.isPresent() || !useRegistry) {
            return existingValue;
        }
        if (registry.isPresent()) {
            return registry.get().first(contract);
        }
        return Services.first(contract);
    }
}

