/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm;

import java.util.Comparator;
import java.util.stream.Stream;
import org.hyperledger.besu.datatypes.HardforkId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum EvmSpecVersion {
    FRONTIER((HardforkId)HardforkId.MainnetHardforkId.FRONTIER, Integer.MAX_VALUE, Integer.MAX_VALUE, 0),
    HOMESTEAD((HardforkId)HardforkId.MainnetHardforkId.HOMESTEAD, Integer.MAX_VALUE, Integer.MAX_VALUE, 0),
    TANGERINE_WHISTLE((HardforkId)HardforkId.MainnetHardforkId.TANGERINE_WHISTLE, Integer.MAX_VALUE, Integer.MAX_VALUE, 0),
    SPURIOUS_DRAGON((HardforkId)HardforkId.MainnetHardforkId.SPURIOUS_DRAGON, 24576, Integer.MAX_VALUE, 0),
    BYZANTIUM((HardforkId)HardforkId.MainnetHardforkId.BYZANTIUM, 24576, Integer.MAX_VALUE, 0),
    CONSTANTINOPLE((HardforkId)HardforkId.MainnetHardforkId.CONSTANTINOPLE, 24576, Integer.MAX_VALUE, 0),
    PETERSBURG((HardforkId)HardforkId.MainnetHardforkId.PETERSBURG, 24576, Integer.MAX_VALUE, 0),
    ISTANBUL((HardforkId)HardforkId.MainnetHardforkId.ISTANBUL, 24576, Integer.MAX_VALUE, 0),
    BERLIN((HardforkId)HardforkId.MainnetHardforkId.BERLIN, 24576, Integer.MAX_VALUE, 0),
    LONDON((HardforkId)HardforkId.MainnetHardforkId.LONDON, 24576, Integer.MAX_VALUE, 0),
    PARIS((HardforkId)HardforkId.MainnetHardforkId.PARIS, 24576, Integer.MAX_VALUE, 0),
    SHANGHAI((HardforkId)HardforkId.MainnetHardforkId.SHANGHAI, 24576, 49152, 0),
    CANCUN((HardforkId)HardforkId.MainnetHardforkId.CANCUN, 24576, 49152, 0),
    CANCUN_EOF((HardforkId)HardforkId.MainnetHardforkId.CANCUN_EOF, 24576, 49152, 1),
    PRAGUE((HardforkId)HardforkId.MainnetHardforkId.PRAGUE, 24576, 49152, 0),
    OSAKA((HardforkId)HardforkId.MainnetHardforkId.OSAKA, 24576, 49152, 1),
    AMSTERDAM((HardforkId)HardforkId.MainnetHardforkId.AMSTERDAM, 24576, 49152, 1),
    BOGOTA((HardforkId)HardforkId.MainnetHardforkId.BOGOTA, 24576, 49152, 1),
    POLIS((HardforkId)HardforkId.MainnetHardforkId.POLIS, 24576, 49152, 1),
    BANGKOK((HardforkId)HardforkId.MainnetHardforkId.BANGKOK, 24576, 49152, 1),
    FUTURE_EIPS((HardforkId)HardforkId.MainnetHardforkId.FUTURE_EIPS, 24576, 49152, 1),
    EXPERIMENTAL_EIPS((HardforkId)HardforkId.MainnetHardforkId.EXPERIMENTAL_EIPS, 24576, 49152, 1);

    private static final Logger LOGGER;
    final HardforkId initialHardfork;
    final int maxEofVersion;
    final int maxCodeSize;
    final int maxInitcodeSize;
    boolean versionWarned = false;

    private EvmSpecVersion(HardforkId initialHarfork, int maxCodeSize, int maxInitcodeSize, int maxEofVersion) {
        this.initialHardfork = initialHarfork;
        this.maxEofVersion = maxEofVersion;
        this.maxCodeSize = maxCodeSize;
        this.maxInitcodeSize = maxInitcodeSize;
    }

    public static EvmSpecVersion defaultVersion() {
        EvmSpecVersion answer = null;
        for (EvmSpecVersion version : EvmSpecVersion.values()) {
            if (!version.initialHardfork.finalized()) continue;
            answer = version;
        }
        return answer;
    }

    public int getMaxEofVersion() {
        return this.maxEofVersion;
    }

    public int getMaxCodeSize() {
        return this.maxCodeSize;
    }

    public int getMaxInitcodeSize() {
        return this.maxInitcodeSize;
    }

    public String getName() {
        return this.initialHardfork.name();
    }

    public String getDescription() {
        return this.initialHardfork.description();
    }

    public void maybeWarnVersion() {
        if (this.versionWarned) {
            return;
        }
        if (!this.initialHardfork.finalized()) {
            LOGGER.error("****** Not for Production Network Use ******\nExecuting code from EVM Spec Version {}, which has not been finalized.\n****** Not for Production Network Use ******", (Object)this.name());
        }
        this.versionWarned = true;
    }

    public static EvmSpecVersion fromName(String name) {
        if ("prague".equalsIgnoreCase(name)) {
            return OSAKA;
        }
        if ("cancuneof".equalsIgnoreCase(name)) {
            return CANCUN_EOF;
        }
        for (EvmSpecVersion version : EvmSpecVersion.values()) {
            if (!version.name().equalsIgnoreCase(name)) continue;
            return version;
        }
        return null;
    }

    public static EvmSpecVersion mostRecent() {
        return Stream.of(EvmSpecVersion.values()).filter(v -> v.initialHardfork.finalized()).max(Comparator.naturalOrder()).orElseThrow();
    }

    static {
        LOGGER = LoggerFactory.getLogger(EvmSpecVersion.class);
    }
}

