/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.account;

import java.util.Optional;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.worldstate.WorldUpdater;

abstract class AbstractCodeDelegationAccount
implements Account {
    private final WorldUpdater worldUpdater;
    private final GasCalculator gasCalculator;
    protected final Address codeDelegationAddress;

    protected AbstractCodeDelegationAccount(WorldUpdater worldUpdater, Address codeDelegationAddress, GasCalculator gasCalculator) {
        this.worldUpdater = worldUpdater;
        this.gasCalculator = gasCalculator;
        this.codeDelegationAddress = codeDelegationAddress;
    }

    @Override
    public Optional<Bytes> getCodeDelegationTargetCode() {
        return this.resolveCodeDelegationTargetCode();
    }

    @Override
    public Optional<Hash> getCodeDelegationTargetHash() {
        return this.getCodeDelegationTargetCode().map(Hash::hash);
    }

    @Override
    public Optional<Address> codeDelegationAddress() {
        return Optional.of(this.codeDelegationAddress);
    }

    @Override
    public boolean hasDelegatedCode() {
        return true;
    }

    private Optional<Account> getDelegatedAccount() {
        return Optional.ofNullable(this.worldUpdater.getAccount(this.codeDelegationAddress));
    }

    private Optional<Bytes> resolveCodeDelegationTargetCode() {
        Optional<Account> maybeDelegatedAccount = this.getDelegatedAccount();
        if (this.gasCalculator.isPrecompile(this.codeDelegationAddress) || maybeDelegatedAccount.isEmpty()) {
            return Optional.of(Bytes.EMPTY);
        }
        return Optional.of(maybeDelegatedAccount.get().getCode());
    }
}

