/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.code;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.MutableBytes;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.code.CodeSection;
import org.hyperledger.besu.evm.code.EOFLayout;
import org.hyperledger.besu.evm.internal.Words;

public class CodeV1
implements Code {
    private final Supplier<Hash> codeHash;
    EOFLayout eofLayout;

    CodeV1(EOFLayout eofLayout) {
        this.eofLayout = eofLayout;
        this.codeHash = Suppliers.memoize(() -> Hash.hash((Bytes)eofLayout.container()));
    }

    @Override
    public int getSize() {
        return this.eofLayout.container().size();
    }

    @Override
    public CodeSection getCodeSection(int section) {
        Preconditions.checkArgument((section >= 0 ? 1 : 0) != 0, (Object)"Section number is positive");
        Preconditions.checkArgument((section < this.eofLayout.getCodeSectionCount() ? 1 : 0) != 0, (Object)"Section index is valid");
        return this.eofLayout.getCodeSection(section);
    }

    @Override
    public int getCodeSectionCount() {
        return this.eofLayout.getCodeSectionCount();
    }

    @Override
    public Bytes getBytes() {
        return this.eofLayout.container();
    }

    @Override
    public Hash getCodeHash() {
        return this.codeHash.get();
    }

    @Override
    public boolean isJumpDestInvalid(int jumpDestination) {
        return true;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public int getEofVersion() {
        return this.eofLayout.version();
    }

    @Override
    public int getSubcontainerCount() {
        return this.eofLayout.getSubcontainerCount();
    }

    @Override
    public Optional<Code> getSubContainer(int index, Bytes auxData, EVM evm) {
        Code subContainerCode;
        Bytes codeToLoad;
        EOFLayout subcontainerLayout = this.eofLayout.getSubcontainer(index);
        if (auxData != null && !auxData.isEmpty()) {
            codeToLoad = subcontainerLayout.writeContainer(auxData);
            if (codeToLoad == null) {
                return Optional.empty();
            }
        } else {
            if (subcontainerLayout.dataLength() != subcontainerLayout.data().size()) {
                return Optional.empty();
            }
            codeToLoad = subcontainerLayout.container();
        }
        return (subContainerCode = evm.getCodeUncached(codeToLoad)).isValid() && subContainerCode.getEofVersion() > 0 ? Optional.of(subContainerCode) : Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodeV1 codeV1 = (CodeV1)o;
        return this.codeHash.equals(codeV1.codeHash) && Objects.equals(this.eofLayout, codeV1.eofLayout);
    }

    public int hashCode() {
        return Objects.hash(this.codeHash, this.eofLayout);
    }

    @Override
    public Bytes getData(int offset, int length) {
        Bytes data = this.eofLayout.data();
        int dataLen = data.size();
        if (offset > dataLen) {
            return Bytes.EMPTY;
        }
        if (offset + length > dataLen) {
            byte[] result = new byte[length];
            MutableBytes mbytes = MutableBytes.wrap((byte[])result);
            data.slice(offset).copyTo(mbytes, 0);
            return Bytes.wrap((byte[])result);
        }
        return data.slice(offset, length);
    }

    @Override
    public int getDataSize() {
        return this.eofLayout.data().size();
    }

    @Override
    public int getDeclaredDataSize() {
        return this.eofLayout.dataLength();
    }

    @Override
    public int readBigEndianI16(int index) {
        return Words.readBigEndianI16(index, this.eofLayout.container().toArrayUnsafe());
    }

    @Override
    public int readBigEndianU16(int index) {
        return Words.readBigEndianU16(index, this.eofLayout.container().toArrayUnsafe());
    }

    @Override
    public int readU8(int index) {
        return this.eofLayout.container().toArrayUnsafe()[index] & 0xFF;
    }

    @Override
    public String prettyPrint() {
        StringWriter sw = new StringWriter();
        this.eofLayout.prettyPrint(new PrintWriter((Writer)sw, true), "", "");
        return sw.toString();
    }

    public EOFLayout getEofLayout() {
        return this.eofLayout;
    }
}

