/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.code;

import com.google.common.base.Preconditions;

public record OpcodeInfo(String name, int opcode, boolean valid, boolean terminal, int inputs, int outputs, int stackDelta, int pcAdvance) {
    static final OpcodeInfo[] V1_OPCODES = new OpcodeInfo[]{OpcodeInfo.terminalOpcode("STOP", 0, 0, 0, 1), OpcodeInfo.validOpcode("ADD", 1, 2, 1, 1), OpcodeInfo.validOpcode("MUL", 2, 2, 1, 1), OpcodeInfo.validOpcode("SUB", 3, 2, 1, 1), OpcodeInfo.validOpcode("DIV", 4, 2, 1, 1), OpcodeInfo.validOpcode("SDIV", 5, 2, 1, 1), OpcodeInfo.validOpcode("MOD", 6, 2, 1, 1), OpcodeInfo.validOpcode("SMOD", 7, 2, 1, 1), OpcodeInfo.validOpcode("ADDMOD", 8, 3, 1, 1), OpcodeInfo.validOpcode("MULMOD", 9, 3, 1, 1), OpcodeInfo.validOpcode("EXP", 10, 2, 1, 1), OpcodeInfo.validOpcode("SIGNEXTEND", 11, 2, 1, 1), OpcodeInfo.unallocatedOpcode(12), OpcodeInfo.unallocatedOpcode(13), OpcodeInfo.unallocatedOpcode(14), OpcodeInfo.unallocatedOpcode(15), OpcodeInfo.validOpcode("LT", 16, 2, 1, 1), OpcodeInfo.validOpcode("GT", 17, 2, 1, 1), OpcodeInfo.validOpcode("SLT", 18, 2, 1, 1), OpcodeInfo.validOpcode("SGT", 19, 2, 1, 1), OpcodeInfo.validOpcode("EQ", 20, 2, 1, 1), OpcodeInfo.validOpcode("ISZERO", 21, 1, 1, 1), OpcodeInfo.validOpcode("AND", 22, 2, 1, 1), OpcodeInfo.validOpcode("OR", 23, 2, 1, 1), OpcodeInfo.validOpcode("XOR", 24, 2, 1, 1), OpcodeInfo.validOpcode("NOT", 25, 1, 1, 1), OpcodeInfo.validOpcode("BYTE", 26, 2, 1, 1), OpcodeInfo.validOpcode("SHL", 27, 2, 1, 1), OpcodeInfo.validOpcode("SHR", 28, 2, 1, 1), OpcodeInfo.validOpcode("SAR", 29, 2, 1, 1), OpcodeInfo.unallocatedOpcode(30), OpcodeInfo.unallocatedOpcode(31), OpcodeInfo.validOpcode("SHA3", 32, 2, 1, 1), OpcodeInfo.unallocatedOpcode(33), OpcodeInfo.unallocatedOpcode(34), OpcodeInfo.unallocatedOpcode(35), OpcodeInfo.unallocatedOpcode(36), OpcodeInfo.unallocatedOpcode(37), OpcodeInfo.unallocatedOpcode(38), OpcodeInfo.unallocatedOpcode(39), OpcodeInfo.unallocatedOpcode(40), OpcodeInfo.unallocatedOpcode(41), OpcodeInfo.unallocatedOpcode(42), OpcodeInfo.unallocatedOpcode(43), OpcodeInfo.unallocatedOpcode(44), OpcodeInfo.unallocatedOpcode(45), OpcodeInfo.unallocatedOpcode(46), OpcodeInfo.unallocatedOpcode(47), OpcodeInfo.validOpcode("ADDRESS", 48, 0, 1, 1), OpcodeInfo.validOpcode("BALANCE", 49, 1, 1, 1), OpcodeInfo.validOpcode("ORIGIN", 50, 0, 1, 1), OpcodeInfo.validOpcode("CALLER", 51, 0, 1, 1), OpcodeInfo.validOpcode("CALLVALUE", 52, 0, 1, 1), OpcodeInfo.validOpcode("CALLDATALOAD", 53, 1, 1, 1), OpcodeInfo.validOpcode("CALLDATASIZE", 54, 0, 1, 1), OpcodeInfo.validOpcode("CALLDATACOPY", 55, 3, 0, 1), OpcodeInfo.invalidOpcode("CODESIZE", 56), OpcodeInfo.invalidOpcode("CODECOPY", 57), OpcodeInfo.validOpcode("GASPRICE", 58, 0, 1, 1), OpcodeInfo.invalidOpcode("EXTCODESIZE", 59), OpcodeInfo.invalidOpcode("EXTCODECOPY", 60), OpcodeInfo.validOpcode("RETURNDATASIZE", 61, 0, 1, 1), OpcodeInfo.validOpcode("RETURNDATACOPY", 62, 3, 0, 1), OpcodeInfo.invalidOpcode("EXTCODEHASH", 63), OpcodeInfo.validOpcode("BLOCKHASH", 64, 1, 1, 1), OpcodeInfo.validOpcode("COINBASE", 65, 0, 1, 1), OpcodeInfo.validOpcode("TIMESTAMP", 66, 0, 1, 1), OpcodeInfo.validOpcode("NUMBER", 67, 0, 1, 1), OpcodeInfo.validOpcode("PREVRANDAO", 68, 0, 1, 1), OpcodeInfo.validOpcode("GASLIMIT", 69, 0, 1, 1), OpcodeInfo.validOpcode("CHAINID", 70, 0, 1, 1), OpcodeInfo.validOpcode("SELFBALANCE", 71, 0, 1, 1), OpcodeInfo.validOpcode("BASEFEE", 72, 0, 1, 1), OpcodeInfo.validOpcode("BLOBAHASH", 73, 1, 1, 1), OpcodeInfo.validOpcode("BLOBBASEFEE", 74, 0, 1, 1), OpcodeInfo.unallocatedOpcode(75), OpcodeInfo.unallocatedOpcode(76), OpcodeInfo.unallocatedOpcode(77), OpcodeInfo.unallocatedOpcode(78), OpcodeInfo.unallocatedOpcode(79), OpcodeInfo.validOpcode("POP", 80, 1, 0, 1), OpcodeInfo.validOpcode("MLOAD", 81, 1, 1, 1), OpcodeInfo.validOpcode("MSTORE", 82, 2, 0, 1), OpcodeInfo.validOpcode("MSTORE8", 83, 2, 0, 1), OpcodeInfo.validOpcode("SLOAD", 84, 1, 1, 1), OpcodeInfo.validOpcode("SSTORE", 85, 2, 0, 1), OpcodeInfo.invalidOpcode("JUMP", 86), OpcodeInfo.invalidOpcode("JUMPI", 87), OpcodeInfo.invalidOpcode("PC", 88), OpcodeInfo.validOpcode("MSIZE", 89, 0, 1, 1), OpcodeInfo.invalidOpcode("GAS", 90), OpcodeInfo.validOpcode("NOOP", 91, 0, 0, 1), OpcodeInfo.validOpcode("TLOAD", 92, 1, 1, 1), OpcodeInfo.validOpcode("TSTORE", 93, 2, 0, 1), OpcodeInfo.validOpcode("MCOPY", 94, 3, 0, 1), OpcodeInfo.validOpcode("PUSH0", 95, 0, 1, 1), OpcodeInfo.validOpcode("PUSH1", 96, 0, 1, 2), OpcodeInfo.validOpcode("PUSH2", 97, 0, 1, 3), OpcodeInfo.validOpcode("PUSH3", 98, 0, 1, 4), OpcodeInfo.validOpcode("PUSH4", 99, 0, 1, 5), OpcodeInfo.validOpcode("PUSH5", 100, 0, 1, 6), OpcodeInfo.validOpcode("PUSH6", 101, 0, 1, 7), OpcodeInfo.validOpcode("PUSH7", 102, 0, 1, 8), OpcodeInfo.validOpcode("PUSH8", 103, 0, 1, 9), OpcodeInfo.validOpcode("PUSH9", 104, 0, 1, 10), OpcodeInfo.validOpcode("PUSH10", 105, 0, 1, 11), OpcodeInfo.validOpcode("PUSH11", 106, 0, 1, 12), OpcodeInfo.validOpcode("PUSH12", 107, 0, 1, 13), OpcodeInfo.validOpcode("PUSH13", 108, 0, 1, 14), OpcodeInfo.validOpcode("PUSH14", 109, 0, 1, 15), OpcodeInfo.validOpcode("PUSH15", 110, 0, 1, 16), OpcodeInfo.validOpcode("PUSH16", 111, 0, 1, 17), OpcodeInfo.validOpcode("PUSH17", 112, 0, 1, 18), OpcodeInfo.validOpcode("PUSH18", 113, 0, 1, 19), OpcodeInfo.validOpcode("PUSH19", 114, 0, 1, 20), OpcodeInfo.validOpcode("PUSH20", 115, 0, 1, 21), OpcodeInfo.validOpcode("PUSH21", 116, 0, 1, 22), OpcodeInfo.validOpcode("PUSH22", 117, 0, 1, 23), OpcodeInfo.validOpcode("PUSH23", 118, 0, 1, 24), OpcodeInfo.validOpcode("PUSH24", 119, 0, 1, 25), OpcodeInfo.validOpcode("PUSH25", 120, 0, 1, 26), OpcodeInfo.validOpcode("PUSH26", 121, 0, 1, 27), OpcodeInfo.validOpcode("PUSH27", 122, 0, 1, 28), OpcodeInfo.validOpcode("PUSH28", 123, 0, 1, 29), OpcodeInfo.validOpcode("PUSH29", 124, 0, 1, 30), OpcodeInfo.validOpcode("PUSH30", 125, 0, 1, 31), OpcodeInfo.validOpcode("PUSH31", 126, 0, 1, 32), OpcodeInfo.validOpcode("PUSH32", 127, 0, 1, 33), OpcodeInfo.validOpcode("DUP1", 128, 1, 2, 1), OpcodeInfo.validOpcode("DUP2", 129, 2, 3, 1), OpcodeInfo.validOpcode("DUP3", 130, 3, 4, 1), OpcodeInfo.validOpcode("DUP4", 131, 4, 5, 1), OpcodeInfo.validOpcode("DUP5", 132, 5, 6, 1), OpcodeInfo.validOpcode("DUP6", 133, 6, 7, 1), OpcodeInfo.validOpcode("DUP7", 134, 7, 8, 1), OpcodeInfo.validOpcode("DUP8", 135, 8, 9, 1), OpcodeInfo.validOpcode("DUP9", 136, 9, 10, 1), OpcodeInfo.validOpcode("DUP10", 137, 10, 11, 1), OpcodeInfo.validOpcode("DUP11", 138, 11, 12, 1), OpcodeInfo.validOpcode("DUP12", 139, 12, 13, 1), OpcodeInfo.validOpcode("DUP13", 140, 13, 14, 1), OpcodeInfo.validOpcode("DUP14", 141, 14, 15, 1), OpcodeInfo.validOpcode("DUP15", 142, 15, 16, 1), OpcodeInfo.validOpcode("DUP16", 143, 16, 17, 1), OpcodeInfo.validOpcode("SWAP1", 144, 2, 2, 1), OpcodeInfo.validOpcode("SWAP2", 145, 3, 3, 1), OpcodeInfo.validOpcode("SWAP3", 146, 4, 4, 1), OpcodeInfo.validOpcode("SWAP4", 147, 5, 5, 1), OpcodeInfo.validOpcode("SWAP5", 148, 6, 6, 1), OpcodeInfo.validOpcode("SWAP6", 149, 7, 7, 1), OpcodeInfo.validOpcode("SWAP7", 150, 8, 8, 1), OpcodeInfo.validOpcode("SWAP8", 151, 9, 9, 1), OpcodeInfo.validOpcode("SWAP9", 152, 10, 10, 1), OpcodeInfo.validOpcode("SWAP10", 153, 11, 11, 1), OpcodeInfo.validOpcode("SWAP11", 154, 12, 12, 1), OpcodeInfo.validOpcode("SWAP12", 155, 13, 13, 1), OpcodeInfo.validOpcode("SWAP13", 156, 14, 14, 1), OpcodeInfo.validOpcode("SWAP14", 157, 15, 15, 1), OpcodeInfo.validOpcode("SWAP15", 158, 16, 16, 1), OpcodeInfo.validOpcode("SWAP16", 159, 17, 17, 1), OpcodeInfo.validOpcode("LOG0", 160, 2, 0, 1), OpcodeInfo.validOpcode("LOG1", 161, 3, 0, 1), OpcodeInfo.validOpcode("LOG2", 162, 4, 0, 1), OpcodeInfo.validOpcode("LOG3", 163, 5, 0, 1), OpcodeInfo.validOpcode("LOG4", 164, 6, 0, 1), OpcodeInfo.unallocatedOpcode(165), OpcodeInfo.unallocatedOpcode(166), OpcodeInfo.unallocatedOpcode(167), OpcodeInfo.unallocatedOpcode(168), OpcodeInfo.unallocatedOpcode(169), OpcodeInfo.unallocatedOpcode(170), OpcodeInfo.unallocatedOpcode(171), OpcodeInfo.unallocatedOpcode(172), OpcodeInfo.unallocatedOpcode(173), OpcodeInfo.unallocatedOpcode(174), OpcodeInfo.unallocatedOpcode(175), OpcodeInfo.unallocatedOpcode(176), OpcodeInfo.unallocatedOpcode(177), OpcodeInfo.unallocatedOpcode(178), OpcodeInfo.unallocatedOpcode(179), OpcodeInfo.unallocatedOpcode(180), OpcodeInfo.unallocatedOpcode(181), OpcodeInfo.unallocatedOpcode(182), OpcodeInfo.unallocatedOpcode(183), OpcodeInfo.unallocatedOpcode(184), OpcodeInfo.unallocatedOpcode(185), OpcodeInfo.unallocatedOpcode(186), OpcodeInfo.unallocatedOpcode(187), OpcodeInfo.unallocatedOpcode(188), OpcodeInfo.unallocatedOpcode(189), OpcodeInfo.unallocatedOpcode(190), OpcodeInfo.unallocatedOpcode(191), OpcodeInfo.unallocatedOpcode(192), OpcodeInfo.unallocatedOpcode(193), OpcodeInfo.unallocatedOpcode(194), OpcodeInfo.unallocatedOpcode(195), OpcodeInfo.unallocatedOpcode(196), OpcodeInfo.unallocatedOpcode(197), OpcodeInfo.unallocatedOpcode(198), OpcodeInfo.unallocatedOpcode(199), OpcodeInfo.unallocatedOpcode(200), OpcodeInfo.unallocatedOpcode(201), OpcodeInfo.unallocatedOpcode(202), OpcodeInfo.unallocatedOpcode(203), OpcodeInfo.unallocatedOpcode(204), OpcodeInfo.unallocatedOpcode(205), OpcodeInfo.unallocatedOpcode(206), OpcodeInfo.unallocatedOpcode(207), OpcodeInfo.validOpcode("DATALOAD", 208, 1, 1, 1), OpcodeInfo.validOpcode("DATALOADN", 209, 0, 1, 3), OpcodeInfo.validOpcode("DATASIZE", 210, 0, 1, 1), OpcodeInfo.validOpcode("DATACOPY", 211, 3, 0, 1), OpcodeInfo.unallocatedOpcode(212), OpcodeInfo.unallocatedOpcode(213), OpcodeInfo.unallocatedOpcode(214), OpcodeInfo.unallocatedOpcode(215), OpcodeInfo.unallocatedOpcode(216), OpcodeInfo.unallocatedOpcode(217), OpcodeInfo.unallocatedOpcode(218), OpcodeInfo.unallocatedOpcode(219), OpcodeInfo.unallocatedOpcode(220), OpcodeInfo.unallocatedOpcode(221), OpcodeInfo.unallocatedOpcode(222), OpcodeInfo.unallocatedOpcode(223), OpcodeInfo.terminalOpcode("RJUMP", 224, 0, 0, 3), OpcodeInfo.validOpcode("RJUMPI", 225, 1, 0, 3), OpcodeInfo.validOpcode("RJUMPV", 226, 1, 0, 2), OpcodeInfo.validOpcode("CALLF", 227, 0, 0, 3), OpcodeInfo.terminalOpcode("RETF", 228, 0, 0, 1), OpcodeInfo.terminalOpcode("JUMPF", 229, 0, 0, 3), OpcodeInfo.validOpcode("DUPN", 230, 0, 1, 2), OpcodeInfo.validOpcode("SWAPN", 231, 0, 0, 2), OpcodeInfo.validOpcode("EXCHANGE", 232, 0, 0, 2), OpcodeInfo.unallocatedOpcode(233), OpcodeInfo.unallocatedOpcode(234), OpcodeInfo.unallocatedOpcode(235), OpcodeInfo.validOpcode("EOFCREATE", 236, 4, 1, 2), OpcodeInfo.unallocatedOpcode(237), OpcodeInfo.terminalOpcode("RETURNCONTRACT", 238, 2, 1, 2), OpcodeInfo.unallocatedOpcode(239), OpcodeInfo.invalidOpcode("CREATE", 240), OpcodeInfo.invalidOpcode("CALL", 241), OpcodeInfo.invalidOpcode("CALLCODE", 242), OpcodeInfo.terminalOpcode("RETURN", 243, 2, 0, 1), OpcodeInfo.invalidOpcode("DELEGATECALL", 244), OpcodeInfo.invalidOpcode("CREATE2", 245), OpcodeInfo.unallocatedOpcode(246), OpcodeInfo.validOpcode("RETURNDATALOAD", 247, 1, 1, 1), OpcodeInfo.validOpcode("EXTCALL", 248, 4, 1, 1), OpcodeInfo.validOpcode("EXTDELEGATECALL", 249, 3, 1, 1), OpcodeInfo.invalidOpcode("STATICCALL", 250), OpcodeInfo.validOpcode("EXTSTATICCALL", 251, 3, 1, 1), OpcodeInfo.unallocatedOpcode(252), OpcodeInfo.terminalOpcode("REVERT", 253, 2, 0, 1), OpcodeInfo.terminalOpcode("INVALID", 254, 0, 0, 1), OpcodeInfo.invalidOpcode("SELFDESTRUCT", 255)};

    static OpcodeInfo unallocatedOpcode(int opcode) {
        return new OpcodeInfo("-", opcode, false, false, 0, 0, 0, 1);
    }

    static OpcodeInfo invalidOpcode(String name, int opcode) {
        return new OpcodeInfo(name, opcode, false, false, 0, 0, 0, 1);
    }

    static OpcodeInfo terminalOpcode(String name, int opcode, int inputs, int outputs, int pcAdvance) {
        return new OpcodeInfo(name, opcode, true, true, inputs, outputs, outputs - inputs, pcAdvance);
    }

    static OpcodeInfo validOpcode(String name, int opcode, int inputs, int outputs, int pcAdvance) {
        return new OpcodeInfo(name, opcode, true, false, inputs, outputs, outputs - inputs, pcAdvance);
    }

    public static OpcodeInfo getOpcode(int i) {
        Preconditions.checkArgument((i >= 0 && i <= 255 ? 1 : 0) != 0);
        return V1_OPCODES[i];
    }
}

