/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.contractvalidation;

import java.util.Optional;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.contractvalidation.ContractValidationRule;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefixCodeRule
implements ContractValidationRule {
    private static final Logger LOG = LoggerFactory.getLogger(PrefixCodeRule.class);
    private static final byte FORMAT_RESERVED = -17;

    @Override
    public Optional<ExceptionalHaltReason> validate(Bytes contractCode, MessageFrame frame, EVM evm) {
        if (!contractCode.isEmpty() && contractCode.get(0) == -17) {
            LOG.trace("Contract creation error: code cannot start with {}", (Object)-17);
            return Optional.of(ExceptionalHaltReason.INVALID_CODE);
        }
        return Optional.empty();
    }

    public static ContractValidationRule of() {
        return new PrefixCodeRule();
    }
}

