/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.gascalculator;

import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.gascalculator.ShanghaiGasCalculator;

public class CancunGasCalculator
extends ShanghaiGasCalculator {
    private static final int DEFAULT_TARGET_BLOBS_PER_BLOCK_CANCUN = 3;
    private final long targetBlobGasPerBlock;
    private static final long TLOAD_GAS = 100L;
    private static final long TSTORE_GAS = 100L;
    private static final long BLOB_GAS_PER_BLOB = 131072L;

    public CancunGasCalculator() {
        this(Address.KZG_POINT_EVAL.toArrayUnsafe()[19], 3);
    }

    public CancunGasCalculator(int targetBlobsPerBlock) {
        this(Address.KZG_POINT_EVAL.toArrayUnsafe()[19], targetBlobsPerBlock);
    }

    protected CancunGasCalculator(int maxPrecompile, int targetBlobsPerBlock) {
        super(maxPrecompile);
        this.targetBlobGasPerBlock = this.getBlobGasPerBlob() * (long)targetBlobsPerBlock;
    }

    @Override
    public long getTransientLoadOperationGasCost() {
        return 100L;
    }

    @Override
    public long getTransientStoreOperationGasCost() {
        return 100L;
    }

    @Override
    public long blobGasCost(long blobCount) {
        return this.getBlobGasPerBlob() * blobCount;
    }

    @Override
    public long getBlobGasPerBlob() {
        return 131072L;
    }

    public long getTargetBlobGasPerBlock() {
        return this.targetBlobGasPerBlock;
    }

    @Override
    public long computeExcessBlobGas(long parentExcessBlobGas, long parentBlobGasUsed) {
        long currentExcessBlobGas = parentExcessBlobGas + parentBlobGasUsed;
        if (currentExcessBlobGas < this.targetBlobGasPerBlock) {
            return 0L;
        }
        return currentExcessBlobGas - this.targetBlobGasPerBlock;
    }
}

