/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.gascalculator;

import java.util.function.Supplier;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Transaction;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;

public class FrontierGasCalculator
implements GasCalculator {
    private static final long TX_DATA_ZERO_COST = 4L;
    private static final long TX_DATA_NON_ZERO_COST = 68L;
    protected static final long TX_BASE_COST = 21000L;
    private static final long TX_CREATE_EXTRA_COST = 0L;
    private static final long CODE_DEPOSIT_BYTE_COST = 200L;
    private static final long ID_PRECOMPILED_BASE_GAS_COST = 15L;
    private static final long ID_PRECOMPILED_WORD_GAS_COST = 3L;
    private static final long ECREC_PRECOMPILED_GAS_COST = 3000L;
    private static final long SHA256_PRECOMPILED_BASE_GAS_COST = 60L;
    private static final long SHA256_PRECOMPILED_WORD_GAS_COST = 12L;
    private static final long RIPEMD160_PRECOMPILED_WORD_GAS_COST = 120L;
    private static final long RIPEMD160_PRECOMPILED_BASE_GAS_COST = 600L;
    private static final long VERY_LOW_TIER_GAS_COST = 3L;
    private static final long LOW_TIER_GAS_COST = 5L;
    private static final long BASE_TIER_GAS_COST = 2L;
    private static final long MID_TIER_GAS_COST = 8L;
    private static final long HIGH_TIER_GAS_COST = 10L;
    private static final long CALL_OPERATION_BASE_GAS_COST = 40L;
    private static final long CALL_VALUE_TRANSFER_GAS_COST = 9000L;
    private static final long ADDITIONAL_CALL_STIPEND = 2300L;
    private static final long NEW_ACCOUNT_GAS_COST = 25000L;
    protected static final long CREATE_OPERATION_GAS_COST = 32000L;
    private static final long COPY_WORD_GAS_COST = 3L;
    private static final long MEMORY_WORD_GAS_COST = 3L;
    private static final long BALANCE_OPERATION_GAS_COST = 20L;
    public static final long BLOCKHASH_OPERATION_GAS_COST = 20L;
    private static final long EXP_OPERATION_BASE_GAS_COST = 10L;
    private static final long EXP_OPERATION_BYTE_GAS_COST = 10L;
    private static final long EXT_CODE_BASE_GAS_COST = 20L;
    private static final long JUMPDEST_OPERATION_GAS_COST = 1L;
    private static final long LOG_OPERATION_BASE_GAS_COST = 375L;
    private static final long LOG_OPERATION_DATA_BYTE_GAS_COST = 8L;
    private static final long LOG_OPERATION_TOPIC_GAS_COST = 375L;
    private static final long SELFDESTRUCT_OPERATION_GAS_COST = 0L;
    private static final long KECCAK256_OPERATION_BASE_GAS_COST = 30L;
    static final long KECCAK256_OPERATION_WORD_GAS_COST = 6L;
    private static final long SLOAD_OPERATION_GAS_COST = 50L;
    public static final long STORAGE_SET_GAS_COST = 20000L;
    public static final long STORAGE_RESET_GAS_COST = 5000L;
    public static final long STORAGE_RESET_REFUND_AMOUNT = 15000L;
    private static final long SELF_DESTRUCT_REFUND_AMOUNT = 24000L;

    @Override
    public long transactionIntrinsicGasCost(Bytes payload, boolean isContractCreation, long baselineGas) {
        long dynamicIntrinsicGasCost = this.dynamicIntrinsicGasCost(payload, isContractCreation, baselineGas);
        if (dynamicIntrinsicGasCost == Long.MIN_VALUE || dynamicIntrinsicGasCost == Long.MAX_VALUE) {
            return dynamicIntrinsicGasCost;
        }
        return Words.clampedAdd(this.getMinimumTransactionCost(), dynamicIntrinsicGasCost);
    }

    protected long dynamicIntrinsicGasCost(Bytes payload, boolean isContractCreation, long baselineGas) {
        long zeroBytes;
        int payloadSize = payload.size();
        long cost = Words.clampedAdd(this.callDataCost(payloadSize, zeroBytes = FrontierGasCalculator.zeroBytes(payload)), baselineGas);
        if (cost == Long.MIN_VALUE || cost == Long.MAX_VALUE) {
            return cost;
        }
        if (isContractCreation && ((cost = Words.clampedAdd(cost, this.contractCreationCost(payloadSize))) == Long.MIN_VALUE || cost == Long.MAX_VALUE)) {
            return cost;
        }
        return cost;
    }

    protected long callDataCost(long payloadSize, long zeroBytes) {
        return Words.clampedAdd(68L * (payloadSize - zeroBytes), 4L * zeroBytes);
    }

    protected static long zeroBytes(Bytes payload) {
        int zeros = 0;
        for (int i = 0; i < payload.size(); ++i) {
            if (payload.get(i) != 0) continue;
            ++zeros;
        }
        return zeros;
    }

    protected long contractCreationCost(int ignored) {
        return this.txCreateExtraGasCost();
    }

    protected long txCreateExtraGasCost() {
        return 0L;
    }

    @Override
    public long transactionFloorCost(Bytes payload) {
        return 0L;
    }

    @Override
    public long codeDepositGasCost(int codeSize) {
        return 200L * (long)codeSize;
    }

    @Override
    public long idPrecompiledContractGasCost(Bytes input) {
        return 3L * (long)Words.numWords(input) + 15L;
    }

    @Override
    public long getEcrecPrecompiledContractGasCost() {
        return 3000L;
    }

    @Override
    public long sha256PrecompiledContractGasCost(Bytes input) {
        return 12L * (long)Words.numWords(input) + 60L;
    }

    @Override
    public long ripemd160PrecompiledContractGasCost(Bytes input) {
        return 120L * (long)Words.numWords(input) + 600L;
    }

    @Override
    public long getZeroTierGasCost() {
        return 0L;
    }

    @Override
    public long getVeryLowTierGasCost() {
        return 3L;
    }

    @Override
    public long getLowTierGasCost() {
        return 5L;
    }

    @Override
    public long getBaseTierGasCost() {
        return 2L;
    }

    @Override
    public long getMidTierGasCost() {
        return 8L;
    }

    @Override
    public long getHighTierGasCost() {
        return 10L;
    }

    @Override
    public long callOperationBaseGasCost() {
        return 40L;
    }

    @Override
    public long callValueTransferGasCost() {
        return 9000L;
    }

    @Override
    public long newAccountGasCost() {
        return 25000L;
    }

    @Override
    public long callOperationGasCost(MessageFrame frame, long stipend, long inputDataOffset, long inputDataLength, long outputDataOffset, long outputDataLength, Wei transferValue, Account recipient, Address to) {
        return this.callOperationGasCost(frame, stipend, inputDataOffset, inputDataLength, outputDataOffset, outputDataLength, transferValue, recipient, to, true);
    }

    @Override
    public long callOperationGasCost(MessageFrame frame, long stipend, long inputDataOffset, long inputDataLength, long outputDataOffset, long outputDataLength, Wei transferValue, Account recipient, Address to, boolean accountIsWarm) {
        long inputDataMemoryExpansionCost = this.memoryExpansionGasCost(frame, inputDataOffset, inputDataLength);
        long outputDataMemoryExpansionCost = this.memoryExpansionGasCost(frame, outputDataOffset, outputDataLength);
        long memoryExpansionCost = Math.max(inputDataMemoryExpansionCost, outputDataMemoryExpansionCost);
        long cost = Words.clampedAdd(Words.clampedAdd(this.callOperationBaseGasCost(), stipend), memoryExpansionCost);
        if (!transferValue.isZero()) {
            cost = Words.clampedAdd(cost, this.callValueTransferGasCost());
        }
        if (recipient == null) {
            cost = Words.clampedAdd(cost, this.newAccountGasCost());
        }
        return cost;
    }

    @Override
    public long getAdditionalCallStipend() {
        return 2300L;
    }

    @Override
    public long gasAvailableForChildCall(MessageFrame frame, long stipend, boolean transfersValue) {
        if (transfersValue) {
            return stipend + this.getAdditionalCallStipend();
        }
        return stipend;
    }

    @Override
    public long getMinRetainedGas() {
        return 0L;
    }

    @Override
    public long getMinCalleeGas() {
        return 0L;
    }

    @Override
    @Deprecated(since="24.4.1", forRemoval=true)
    public long createOperationGasCost(MessageFrame frame) {
        long initCodeOffset = Words.clampedToLong(frame.getStackItem(1));
        int initCodeLength = Words.clampedToInt(frame.getStackItem(2));
        return Words.clampedAdd(Words.clampedAdd(this.txCreateCost(), this.memoryExpansionGasCost(frame, initCodeOffset, initCodeLength)), this.initcodeCost(initCodeLength));
    }

    @Override
    @Deprecated(since="24.4.1", forRemoval=true)
    public long create2OperationGasCost(MessageFrame frame) {
        throw new UnsupportedOperationException("CREATE2 operation not supported by " + this.getClass().getSimpleName());
    }

    @Override
    public long txCreateCost() {
        return 32000L;
    }

    @Override
    public long createKeccakCost(int initCodeLength) {
        return Words.clampedMultiply(6L, Words.numWords(initCodeLength));
    }

    @Override
    public long initcodeCost(int initCodeLength) {
        return 0L;
    }

    @Override
    public long gasAvailableForChildCreate(long stipend) {
        return stipend;
    }

    @Override
    public long dataCopyOperationGasCost(MessageFrame frame, long offset, long length) {
        return this.copyWordsToMemoryGasCost(frame, 3L, 3L, offset, length);
    }

    @Override
    public long memoryExpansionGasCost(MessageFrame frame, long offset, long length) {
        long pre = FrontierGasCalculator.memoryCost(frame.memoryWordSize());
        long post = FrontierGasCalculator.memoryCost(frame.calculateMemoryExpansion(offset, length));
        if (post == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return post - pre;
    }

    @Override
    public long getBalanceOperationGasCost() {
        return 20L;
    }

    @Override
    public long getBlockHashOperationGasCost() {
        return 20L;
    }

    protected long expOperationByteGasCost() {
        return 10L;
    }

    @Override
    public long expOperationGasCost(int numBytes) {
        return this.expOperationByteGasCost() * (long)numBytes + 10L;
    }

    protected long extCodeBaseGasCost() {
        return 20L;
    }

    @Override
    public long extCodeCopyOperationGasCost(MessageFrame frame, long offset, long length) {
        return this.copyWordsToMemoryGasCost(frame, this.extCodeBaseGasCost(), 3L, offset, length);
    }

    @Override
    public long extCodeHashOperationGasCost() {
        throw new UnsupportedOperationException("EXTCODEHASH not supported by " + this.getClass().getSimpleName());
    }

    @Override
    public long getExtCodeSizeOperationGasCost() {
        return this.extCodeBaseGasCost();
    }

    @Override
    public long getJumpDestOperationGasCost() {
        return 1L;
    }

    @Override
    public long logOperationGasCost(MessageFrame frame, long dataOffset, long dataLength, int numTopics) {
        return Words.clampedAdd(375L, Words.clampedAdd(Words.clampedMultiply(8L, dataLength), Words.clampedAdd(Words.clampedMultiply(375L, numTopics), this.memoryExpansionGasCost(frame, dataOffset, dataLength))));
    }

    @Override
    public long mLoadOperationGasCost(MessageFrame frame, long offset) {
        return Words.clampedAdd(3L, this.memoryExpansionGasCost(frame, offset, 32L));
    }

    @Override
    public long mStoreOperationGasCost(MessageFrame frame, long offset) {
        return Words.clampedAdd(3L, this.memoryExpansionGasCost(frame, offset, 32L));
    }

    @Override
    public long mStore8OperationGasCost(MessageFrame frame, long offset) {
        return Words.clampedAdd(3L, this.memoryExpansionGasCost(frame, offset, 1L));
    }

    @Override
    public long selfDestructOperationGasCost(Account recipient, Wei inheritance) {
        return 0L;
    }

    @Override
    public long keccak256OperationGasCost(MessageFrame frame, long offset, long length) {
        return this.copyWordsToMemoryGasCost(frame, 30L, 6L, offset, length);
    }

    @Override
    public long getSloadOperationGasCost() {
        return 50L;
    }

    @Override
    public long calculateStorageCost(UInt256 newValue, Supplier<UInt256> currentValue, Supplier<UInt256> originalValue) {
        return !newValue.isZero() && currentValue.get().isZero() ? 20000L : 5000L;
    }

    @Override
    public long calculateStorageRefundAmount(UInt256 newValue, Supplier<UInt256> currentValue, Supplier<UInt256> originalValue) {
        return newValue.isZero() && !currentValue.get().isZero() ? 15000L : 0L;
    }

    @Override
    public long getSelfDestructRefundAmount() {
        return 24000L;
    }

    protected long copyWordsToMemoryGasCost(MessageFrame frame, long baseGasCost, long wordGasCost, long offset, long length) {
        long copyCost = Words.clampedAdd(Words.clampedMultiply(wordGasCost, Words.numWords(Words.clampedToInt(length))), baseGasCost);
        long memoryCost = this.memoryExpansionGasCost(frame, offset, length);
        return Words.clampedAdd(copyCost, memoryCost);
    }

    static long memoryCost(long length) {
        long lengthSquare = Words.clampedMultiply(length, length);
        long base = lengthSquare == Long.MAX_VALUE ? Words.clampedMultiply(length / 512L, length) : lengthSquare / 512L;
        return Words.clampedAdd(Words.clampedMultiply(3L, length), base);
    }

    @Override
    public long getMinimumTransactionCost() {
        return 21000L;
    }

    @Override
    public long calculateGasRefund(Transaction transaction, MessageFrame initialFrame, long ignoredCodeDelegationRefund) {
        long refundAllowance = this.calculateRefundAllowance(transaction, initialFrame);
        return initialFrame.getRemainingGas() + refundAllowance;
    }

    private long calculateRefundAllowance(Transaction transaction, MessageFrame initialFrame) {
        long selfDestructRefund = this.getSelfDestructRefundAmount() * (long)initialFrame.getSelfDestructs().size();
        long executionRefund = initialFrame.getGasRefund() + selfDestructRefund;
        long maxRefundAllowance = (transaction.getGasLimit() - initialFrame.getRemainingGas()) / this.getMaxRefundQuotient();
        return Math.min(executionRefund, maxRefundAllowance);
    }
}

