/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.gascalculator;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Transaction;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.CancunGasCalculator;
import org.hyperledger.besu.evm.internal.Words;

public class PragueGasCalculator
extends CancunGasCalculator {
    private static final long TOTAL_COST_FLOOR_PER_TOKEN = 10L;
    final long existingAccountGasRefund = this.newAccountGasCost() - 12500L;
    private static final int DEFAULT_TARGET_BLOBS_PER_BLOCK_PRAGUE = 6;

    public PragueGasCalculator() {
        this(Address.BLS12_MAP_FP2_TO_G2.toArrayUnsafe()[19], 6);
    }

    public PragueGasCalculator(int targetBlobsPerBlock) {
        this(Address.BLS12_MAP_FP2_TO_G2.toArrayUnsafe()[19], targetBlobsPerBlock);
    }

    protected PragueGasCalculator(int maxPrecompile, int targetBlobsPerBlock) {
        super(maxPrecompile, targetBlobsPerBlock);
    }

    @Override
    public long delegateCodeGasCost(int delegateCodeListLength) {
        return this.newAccountGasCost() * (long)delegateCodeListLength;
    }

    @Override
    public long calculateDelegateCodeGasRefund(long alreadyExistingAccounts) {
        return this.existingAccountGasRefund * alreadyExistingAccounts;
    }

    @Override
    public long calculateGasRefund(Transaction transaction, MessageFrame initialFrame, long codeDelegationRefund) {
        long refundAllowance = this.calculateRefundAllowance(transaction, initialFrame, codeDelegationRefund);
        long executionGasUsed = transaction.getGasLimit() - initialFrame.getRemainingGas() - refundAllowance;
        long transactionFloorCost = this.transactionFloorCost(transaction.getPayload());
        long totalGasUsed = Math.max(executionGasUsed, transactionFloorCost);
        return transaction.getGasLimit() - totalGasUsed;
    }

    private long calculateRefundAllowance(Transaction transaction, MessageFrame initialFrame, long codeDelegationRefund) {
        long selfDestructRefund = this.getSelfDestructRefundAmount() * (long)initialFrame.getSelfDestructs().size();
        long executionRefund = initialFrame.getGasRefund() + selfDestructRefund + codeDelegationRefund;
        long maxRefundAllowance = (transaction.getGasLimit() - initialFrame.getRemainingGas()) / this.getMaxRefundQuotient();
        return Math.min(executionRefund, maxRefundAllowance);
    }

    @Override
    public long transactionFloorCost(Bytes transactionPayload) {
        return Words.clampedAdd(this.getMinimumTransactionCost(), this.tokensInCallData(transactionPayload.size(), PragueGasCalculator.zeroBytes(transactionPayload)) * 10L);
    }

    private long tokensInCallData(long payloadSize, long zeroBytes) {
        return Words.clampedAdd(zeroBytes, (payloadSize - zeroBytes) * 4L);
    }
}

