/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.log;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.bytes.MutableBytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.ethereum.rlp.RLPInput;
import org.hyperledger.besu.ethereum.rlp.RLPOutput;
import org.hyperledger.besu.evm.log.LogTopic;

public class Log {
    private final Address logger;
    private final Bytes data;
    private final ImmutableList<LogTopic> topics;

    @JsonCreator
    public Log(@JsonProperty(value="logger") Address logger, @JsonProperty(value="data") Bytes data, @JsonProperty(value="topics") List<LogTopic> topics) {
        this.logger = logger;
        this.data = data;
        this.topics = ImmutableList.copyOf(topics);
    }

    public void writeTo(RLPOutput out) {
        this.writeTo(out, false);
    }

    public void writeTo(RLPOutput out, boolean compacted) {
        out.startList();
        out.writeBytes((Bytes)this.logger);
        if (compacted) {
            out.writeList(this.topics, (topic, listOut) -> this.encodeTrimmedData((RLPOutput)listOut, (Bytes)topic));
            this.encodeTrimmedData(out, this.data);
        } else {
            out.writeList(this.topics, (topic, listOut) -> listOut.writeBytes((Bytes)topic));
            out.writeBytes(this.data);
        }
        out.endList();
    }

    private void encodeTrimmedData(RLPOutput rlpOutput, Bytes data) {
        rlpOutput.startList();
        Bytes shortData = data.trimLeadingZeros();
        int zeroLeadDataSize = data.size() - shortData.size();
        rlpOutput.writeIntScalar(zeroLeadDataSize);
        rlpOutput.writeBytes(shortData);
        rlpOutput.endList();
    }

    public static Log readFrom(RLPInput in) {
        return Log.readFrom(in, false);
    }

    public static Log readFrom(RLPInput in, boolean compacted) {
        Bytes data;
        List topics;
        in.enterList();
        Address logger = Address.wrap((Bytes)in.readBytes());
        if (compacted) {
            topics = in.readList(listIn -> LogTopic.wrap((Bytes)Bytes32.wrap((Bytes)Log.readTrimmedData(in))));
            data = Bytes.wrap((Bytes[])new Bytes[]{Log.readTrimmedData(in)});
        } else {
            topics = in.readList(listIn -> LogTopic.wrap((Bytes)listIn.readBytes32()));
            data = in.readBytes();
        }
        in.leaveList();
        return new Log(logger, data, topics);
    }

    private static Bytes readTrimmedData(RLPInput in) {
        in.enterList();
        int zeroLeadDataSize = in.readIntScalar();
        Bytes shortData = in.readBytes();
        MutableBytes data = MutableBytes.create((int)(zeroLeadDataSize + shortData.size()));
        data.set(zeroLeadDataSize, shortData);
        in.leaveList();
        return data;
    }

    @JsonProperty(value="logger")
    public Address getLogger() {
        return this.logger;
    }

    @JsonProperty(value="data")
    public Bytes getData() {
        return this.data;
    }

    @JsonProperty(value="topics")
    public List<LogTopic> getTopics() {
        return this.topics;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Log)) {
            return false;
        }
        Log that = (Log)other;
        return this.data.equals((Object)that.data) && this.logger.equals((Object)that.logger) && this.topics.equals(that.topics);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.logger, this.topics);
    }

    public String toString() {
        String joinedTopics = Joiner.on((String)"\n").join(this.topics);
        return String.format("Data: %s\nLogger: %s\nTopics: %s", this.data, this.logger, joinedTopics);
    }
}

