/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.Optional;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.account.MutableAccount;
import org.hyperledger.besu.evm.code.CodeInvalid;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public abstract class AbstractCreateOperation
extends AbstractOperation {
    protected static final Operation.OperationResult UNDERFLOW_RESPONSE = new Operation.OperationResult(0L, ExceptionalHaltReason.INSUFFICIENT_STACK_ITEMS);
    protected static final Operation.OperationResult INVALID_OPERATION = new Operation.OperationResult(0L, ExceptionalHaltReason.INVALID_OPERATION);
    protected final int eofVersion;

    protected AbstractCreateOperation(int opcode, String name, int stackItemsConsumed, int stackItemsProduced, GasCalculator gasCalculator, int eofVersion) {
        super(opcode, name, stackItemsConsumed, stackItemsProduced, gasCalculator);
        this.eofVersion = eofVersion;
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        if (frame.getCode().getEofVersion() != this.eofVersion) {
            return INVALID_OPERATION;
        }
        if (frame.stackSize() < this.getStackItemsConsumed()) {
            return UNDERFLOW_RESPONSE;
        }
        Supplier codeSupplier = Suppliers.memoize(() -> this.getInitCode(frame, evm));
        long cost = this.cost(frame, (java.util.function.Supplier<Code>)codeSupplier);
        if (frame.isStatic()) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.ILLEGAL_STATE_CHANGE);
        }
        if (frame.getRemainingGas() < cost) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
        }
        Wei value = Wei.wrap((Bytes)frame.getStackItem(0));
        Address address = frame.getRecipientAddress();
        MutableAccount account = frame.getWorldUpdater().getAccount(address);
        frame.clearReturnData();
        Code code = (Code)codeSupplier.get();
        if (code != null && code.getSize() > evm.getMaxInitcodeSize()) {
            frame.popStackItems(this.getStackItemsConsumed());
            return new Operation.OperationResult(cost, ExceptionalHaltReason.CODE_TOO_LARGE);
        }
        if (value.compareTo((Bytes)account.getBalance()) > 0 || frame.getDepth() >= 1024 || account.getNonce() == -1L || code == null || code.getEofVersion() != frame.getCode().getEofVersion()) {
            this.fail(frame);
        } else {
            account.incrementNonce();
            if (!code.isValid()) {
                this.fail(frame);
            } else {
                frame.decrementRemainingGas(cost);
                this.spawnChildMessage(frame, code, evm);
                frame.incrementRemainingGas(cost);
            }
        }
        return new Operation.OperationResult(cost, null, this.getPcIncrement());
    }

    protected int getPcIncrement() {
        return 1;
    }

    protected abstract long cost(MessageFrame var1, java.util.function.Supplier<Code> var2);

    protected abstract Address generateTargetContractAddress(MessageFrame var1, Code var2);

    protected abstract Code getInitCode(MessageFrame var1, EVM var2);

    protected void fail(MessageFrame frame) {
        long inputOffset = Words.clampedToLong(frame.getStackItem(1));
        long inputSize = Words.clampedToLong(frame.getStackItem(2));
        frame.readMutableMemory(inputOffset, inputSize);
        frame.popStackItems(this.getStackItemsConsumed());
        frame.pushStackItem(Bytes.EMPTY);
    }

    private void spawnChildMessage(MessageFrame parent, Code code, EVM evm) {
        Wei value = Wei.wrap((Bytes)parent.getStackItem(0));
        Address contractAddress = this.generateTargetContractAddress(parent, code);
        Bytes inputData = this.getInputData(parent);
        long childGasStipend = this.gasCalculator().gasAvailableForChildCreate(parent.getRemainingGas());
        parent.decrementRemainingGas(childGasStipend);
        MessageFrame.builder().parentMessageFrame(parent).type(MessageFrame.Type.CONTRACT_CREATION).initialGas(childGasStipend).address(contractAddress).contract(contractAddress).inputData(inputData).sender(parent.getRecipientAddress()).value(value).apparentValue(value).code(code).completer(child -> this.complete(parent, (MessageFrame)child, evm)).build();
        parent.setState(MessageFrame.State.CODE_SUSPENDED);
    }

    protected Bytes getInputData(MessageFrame frame) {
        return Bytes.EMPTY;
    }

    private void complete(MessageFrame frame, MessageFrame childFrame, EVM evm) {
        frame.setState(MessageFrame.State.CODE_EXECUTING);
        frame.incrementRemainingGas(childFrame.getRemainingGas());
        frame.addLogs(childFrame.getLogs());
        frame.addSelfDestructs(childFrame.getSelfDestructs());
        frame.addCreates(childFrame.getCreates());
        frame.popStackItems(this.getStackItemsConsumed());
        if (childFrame.getState() == MessageFrame.State.COMPLETED_SUCCESS) {
            Code outputCode;
            Code code = outputCode = childFrame.getCreatedCode() != null ? childFrame.getCreatedCode() : evm.getCodeForCreation(childFrame.getOutputData());
            if (outputCode.isValid()) {
                Address createdAddress = childFrame.getContractAddress();
                frame.pushStackItem((Bytes)Words.fromAddress(createdAddress));
                frame.setReturnData(Bytes.EMPTY);
                this.onSuccess(frame, createdAddress);
            } else {
                frame.getWorldUpdater().deleteAccount(childFrame.getRecipientAddress());
                frame.setReturnData(childFrame.getOutputData());
                frame.pushStackItem(Bytes.EMPTY);
                this.onInvalid(frame, (CodeInvalid)outputCode);
            }
        } else {
            frame.setReturnData(childFrame.getOutputData());
            frame.pushStackItem(Bytes.EMPTY);
            this.onFailure(frame, childFrame.getExceptionalHaltReason());
        }
        int currentPC = frame.getPC();
        frame.setPC(currentPC + this.getPcIncrement());
    }

    protected void onSuccess(MessageFrame frame, Address createdAddress) {
    }

    protected void onFailure(MessageFrame frame, Optional<ExceptionalHaltReason> haltReason) {
    }

    protected void onInvalid(MessageFrame frame, CodeInvalid invalidCode) {
    }
}

