/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class CodeCopyOperation
extends AbstractOperation {
    public CodeCopyOperation(GasCalculator gasCalculator) {
        super(57, "CODECOPY", 3, 0, gasCalculator);
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        long memOffset = Words.clampedToLong(frame.popStackItem());
        long sourceOffset = Words.clampedToLong(frame.popStackItem());
        long numBytes = Words.clampedToLong(frame.popStackItem());
        long cost = this.gasCalculator().dataCopyOperationGasCost(frame, memOffset, numBytes);
        if (frame.getRemainingGas() < cost) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
        }
        Code code = frame.getCode();
        frame.writeMemory(memOffset, sourceOffset, numBytes, code.getBytes(), true);
        return new Operation.OperationResult(cost, null);
    }
}

