/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.InvalidOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class DataLoadOperation
extends AbstractFixedCostOperation {
    public DataLoadOperation(GasCalculator gasCalculator) {
        super(208, "DATALOAD", 1, 1, gasCalculator, 4L);
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        Code code = frame.getCode();
        if (code.getEofVersion() == 0) {
            return InvalidOperation.INVALID_RESULT;
        }
        int sourceOffset = Words.clampedToInt(frame.popStackItem());
        Bytes data = code.getData(sourceOffset, 32);
        frame.pushStackItem(data);
        return this.successResponse;
    }
}

