/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.InvalidOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class DupNOperation
extends AbstractFixedCostOperation {
    public static final int OPCODE = 230;
    static final Operation.OperationResult dupSuccess = new Operation.OperationResult(3L, null);

    public DupNOperation(GasCalculator gasCalculator) {
        super(230, "DUPN", 0, 1, gasCalculator, gasCalculator.getVeryLowTierGasCost());
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        Code code = frame.getCode();
        if (code.getEofVersion() == 0) {
            return InvalidOperation.INVALID_RESULT;
        }
        int pc = frame.getPC();
        int depth = code.readU8(pc + 1);
        frame.pushStackItem(frame.getStackItem(depth));
        frame.setPC(pc + 1);
        return dupSuccess;
    }
}

