/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import java.util.Optional;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.InvalidOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class ReturnContractOperation
extends AbstractOperation {
    public static final int OPCODE = 238;

    public ReturnContractOperation(GasCalculator gasCalculator) {
        super(238, "RETURNCONTRACT", 2, 0, gasCalculator);
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        Code code = frame.getCode();
        if (code.getEofVersion() == 0) {
            return InvalidOperation.INVALID_RESULT;
        }
        int pc = frame.getPC();
        int index = code.readU8(pc + 1);
        long from = Words.clampedToLong(frame.popStackItem());
        long length = Words.clampedToLong(frame.popStackItem());
        long cost = this.gasCalculator().memoryExpansionGasCost(frame, from, length);
        if (frame.getRemainingGas() < cost) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
        }
        if (index >= code.getSubcontainerCount()) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.NONEXISTENT_CONTAINER);
        }
        Bytes auxData = frame.readMemory(from, length);
        if (code.getDataSize() + auxData.size() > evm.getMaxCodeSize()) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.CODE_TOO_LARGE);
        }
        if (code.getDataSize() + auxData.size() < code.getDeclaredDataSize()) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.DATA_TOO_SMALL);
        }
        Optional<Code> newCode = code.getSubContainer(index, auxData, evm);
        if (newCode.isEmpty()) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.INVALID_CONTAINER);
        }
        frame.setCreatedCode(newCode.get());
        frame.setState(MessageFrame.State.CODE_SUCCESS);
        return new Operation.OperationResult(cost, null);
    }
}

