/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.precompile;

import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.precompile.AltBN128AddPrecompiledContract;
import org.hyperledger.besu.evm.precompile.AltBN128MulPrecompiledContract;
import org.hyperledger.besu.evm.precompile.AltBN128PairingPrecompiledContract;
import org.hyperledger.besu.evm.precompile.BLAKE2BFPrecompileContract;
import org.hyperledger.besu.evm.precompile.BLS12G1AddPrecompiledContract;
import org.hyperledger.besu.evm.precompile.BLS12G1MultiExpPrecompiledContract;
import org.hyperledger.besu.evm.precompile.BLS12G2AddPrecompiledContract;
import org.hyperledger.besu.evm.precompile.BLS12G2MultiExpPrecompiledContract;
import org.hyperledger.besu.evm.precompile.BLS12MapFp2ToG2PrecompiledContract;
import org.hyperledger.besu.evm.precompile.BLS12MapFpToG1PrecompiledContract;
import org.hyperledger.besu.evm.precompile.BLS12PairingPrecompiledContract;
import org.hyperledger.besu.evm.precompile.BigIntegerModularExponentiationPrecompiledContract;
import org.hyperledger.besu.evm.precompile.ECRECPrecompiledContract;
import org.hyperledger.besu.evm.precompile.IDPrecompiledContract;
import org.hyperledger.besu.evm.precompile.KZGPointEvalPrecompiledContract;
import org.hyperledger.besu.evm.precompile.PrecompileContractRegistry;
import org.hyperledger.besu.evm.precompile.RIPEMD160PrecompiledContract;
import org.hyperledger.besu.evm.precompile.SHA256PrecompiledContract;

public interface MainnetPrecompiledContracts {
    public static PrecompileContractRegistry frontier(GasCalculator gasCalculator) {
        PrecompileContractRegistry precompileContractRegistry = new PrecompileContractRegistry();
        MainnetPrecompiledContracts.populateForFrontier(precompileContractRegistry, gasCalculator);
        return precompileContractRegistry;
    }

    public static void populateForFrontier(PrecompileContractRegistry registry, GasCalculator gasCalculator) {
        registry.put(Address.ECREC, new ECRECPrecompiledContract(gasCalculator));
        registry.put(Address.SHA256, new SHA256PrecompiledContract(gasCalculator));
        registry.put(Address.RIPEMD160, new RIPEMD160PrecompiledContract(gasCalculator));
        registry.put(Address.ID, new IDPrecompiledContract(gasCalculator));
    }

    public static PrecompileContractRegistry homestead(GasCalculator gasCalculator) {
        return MainnetPrecompiledContracts.frontier(gasCalculator);
    }

    public static PrecompileContractRegistry byzantium(GasCalculator gasCalculator) {
        PrecompileContractRegistry precompileContractRegistry = new PrecompileContractRegistry();
        MainnetPrecompiledContracts.populateForByzantium(precompileContractRegistry, gasCalculator);
        return precompileContractRegistry;
    }

    public static void populateForByzantium(PrecompileContractRegistry registry, GasCalculator gasCalculator) {
        MainnetPrecompiledContracts.populateForFrontier(registry, gasCalculator);
        registry.put(Address.MODEXP, new BigIntegerModularExponentiationPrecompiledContract(gasCalculator));
        registry.put(Address.ALTBN128_ADD, AltBN128AddPrecompiledContract.byzantium(gasCalculator));
        registry.put(Address.ALTBN128_MUL, AltBN128MulPrecompiledContract.byzantium(gasCalculator));
        registry.put(Address.ALTBN128_PAIRING, AltBN128PairingPrecompiledContract.byzantium(gasCalculator));
    }

    public static PrecompileContractRegistry istanbul(GasCalculator gasCalculator) {
        PrecompileContractRegistry precompileContractRegistry = new PrecompileContractRegistry();
        MainnetPrecompiledContracts.populateForIstanbul(precompileContractRegistry, gasCalculator);
        return precompileContractRegistry;
    }

    public static void populateForIstanbul(PrecompileContractRegistry registry, GasCalculator gasCalculator) {
        MainnetPrecompiledContracts.populateForByzantium(registry, gasCalculator);
        registry.put(Address.ALTBN128_ADD, AltBN128AddPrecompiledContract.istanbul(gasCalculator));
        registry.put(Address.ALTBN128_MUL, AltBN128MulPrecompiledContract.istanbul(gasCalculator));
        registry.put(Address.ALTBN128_PAIRING, AltBN128PairingPrecompiledContract.istanbul(gasCalculator));
        registry.put(Address.BLAKE2B_F_COMPRESSION, new BLAKE2BFPrecompileContract(gasCalculator));
    }

    public static PrecompileContractRegistry cancun(GasCalculator gasCalculator) {
        PrecompileContractRegistry precompileContractRegistry = new PrecompileContractRegistry();
        MainnetPrecompiledContracts.populateForCancun(precompileContractRegistry, gasCalculator);
        return precompileContractRegistry;
    }

    public static void populateForCancun(PrecompileContractRegistry registry, GasCalculator gasCalculator) {
        MainnetPrecompiledContracts.populateForIstanbul(registry, gasCalculator);
        registry.put(Address.KZG_POINT_EVAL, new KZGPointEvalPrecompiledContract());
    }

    public static PrecompileContractRegistry prague(GasCalculator gasCalculator) {
        PrecompileContractRegistry precompileContractRegistry = new PrecompileContractRegistry();
        MainnetPrecompiledContracts.populateForPrague(precompileContractRegistry, gasCalculator);
        return precompileContractRegistry;
    }

    public static void populateForPrague(PrecompileContractRegistry registry, GasCalculator gasCalculator) {
        MainnetPrecompiledContracts.populateForCancun(registry, gasCalculator);
        registry.put(Address.BLS12_G1ADD, new BLS12G1AddPrecompiledContract());
        registry.put(Address.BLS12_G1MULTIEXP, new BLS12G1MultiExpPrecompiledContract());
        registry.put(Address.BLS12_G2ADD, new BLS12G2AddPrecompiledContract());
        registry.put(Address.BLS12_G2MULTIEXP, new BLS12G2MultiExpPrecompiledContract());
        registry.put(Address.BLS12_PAIRING, new BLS12PairingPrecompiledContract());
        registry.put(Address.BLS12_MAP_FP_TO_G1, new BLS12MapFpToG1PrecompiledContract());
        registry.put(Address.BLS12_MAP_FP2_TO_G2, new BLS12MapFp2ToG2PrecompiledContract());
    }

    public static PrecompileContractRegistry futureEIPs(GasCalculator gasCalculator) {
        PrecompileContractRegistry precompileContractRegistry = new PrecompileContractRegistry();
        MainnetPrecompiledContracts.populateForFutureEIPs(precompileContractRegistry, gasCalculator);
        return precompileContractRegistry;
    }

    public static void populateForFutureEIPs(PrecompileContractRegistry registry, GasCalculator gasCalculator) {
        MainnetPrecompiledContracts.populateForCancun(registry, gasCalculator);
    }
}

