/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.worldstate;

import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;

public class CodeDelegationGasCostHelper {
    private CodeDelegationGasCostHelper() {
    }

    public static long codeDelegationGasCost(MessageFrame frame, GasCalculator gasCalculator, Account account) {
        if (!account.hasDelegatedCode()) {
            return 0L;
        }
        if (account.codeDelegationAddress().isEmpty()) {
            throw new RuntimeException("A delegated code account must have a delegated code address");
        }
        return CodeDelegationGasCostHelper.calculateCodeDelegationResolutionGas(frame, gasCalculator, account.codeDelegationAddress().get());
    }

    private static long calculateCodeDelegationResolutionGas(MessageFrame frame, GasCalculator gasCalculator, Address delegateeAddress) {
        boolean isWarm = frame.warmUpAddress(delegateeAddress) || gasCalculator.isPrecompile(delegateeAddress);
        return isWarm ? gasCalculator.getWarmStorageReadCost() : gasCalculator.getColdAccountAccessCost();
    }
}

