/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.worldstate;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.account.CodeDelegationAccount;
import org.hyperledger.besu.evm.account.MutableAccount;
import org.hyperledger.besu.evm.account.MutableCodeDelegationDelegationAccount;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.worldstate.CodeDelegationHelper;
import org.hyperledger.besu.evm.worldstate.WorldUpdater;

public class CodeDelegationService {
    private final GasCalculator gasCalculator;

    public CodeDelegationService(GasCalculator gasCalculator) {
        this.gasCalculator = gasCalculator;
    }

    public void processCodeDelegation(MutableAccount account, Address codeDelegationAddress) {
        if (codeDelegationAddress.equals((Object)Address.ZERO)) {
            account.setCode(Bytes.EMPTY);
            return;
        }
        account.setCode(Bytes.concatenate((Bytes[])new Bytes[]{CodeDelegationHelper.CODE_DELEGATION_PREFIX, codeDelegationAddress}));
    }

    public boolean canSetCodeDelegation(Account account) {
        return account.getCode().isEmpty() || CodeDelegationHelper.hasCodeDelegation(account.getCode());
    }

    public Account processAccount(WorldUpdater worldUpdater, Account account) {
        if (account == null || !CodeDelegationHelper.hasCodeDelegation(account.getCode())) {
            return account;
        }
        return new CodeDelegationAccount(worldUpdater, account, this.resolveDelegatedAddress(account.getCode()), this.gasCalculator);
    }

    public MutableAccount processMutableAccount(WorldUpdater worldUpdater, MutableAccount account) {
        if (account == null || !CodeDelegationHelper.hasCodeDelegation(account.getCode())) {
            return account;
        }
        return new MutableCodeDelegationDelegationAccount(worldUpdater, account, this.resolveDelegatedAddress(account.getCode()), this.gasCalculator);
    }

    private Address resolveDelegatedAddress(Bytes code) {
        return Address.wrap((Bytes)code.slice(CodeDelegationHelper.CODE_DELEGATION_PREFIX.size()));
    }
}

