/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.networkadmin.impl.handlers;

import com.hedera.hapi.node.base.FeeComponents;
import com.hedera.hapi.node.base.FeeData;
import com.hedera.hapi.node.base.QueryHeader;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ResponseHeader;
import com.hedera.hapi.node.base.ResponseType;
import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.network.NetworkGetVersionInfoQuery;
import com.hedera.hapi.node.network.NetworkGetVersionInfoResponse;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.hapi.node.transaction.Response;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.workflows.PaidQueryHandler;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.QueryContext;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.node.config.data.VersionConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class NetworkGetVersionInfoHandler
extends PaidQueryHandler {
    private static final FeeComponents ZERO_USAGE = FeeComponents.DEFAULT;
    private static final int BYTES_PER_SEMANTIC_VERSION = 12;
    private static final FeeComponents GET_VERSION_INFO_NODE_USAGE = FeeComponents.newBuilder().constant(1L).bpt(212L).bpr(40L).build();
    private static final FeeData FIXED_USAGE = FeeData.newBuilder().networkdata(ZERO_USAGE).servicedata(ZERO_USAGE).nodedata(GET_VERSION_INFO_NODE_USAGE).build();

    @Inject
    public NetworkGetVersionInfoHandler() {
    }

    public QueryHeader extractHeader(@NonNull Query query) {
        Objects.requireNonNull(query);
        return query.networkGetVersionInfoOrThrow().header();
    }

    public Response createEmptyResponse(@NonNull ResponseHeader header) {
        Objects.requireNonNull(header);
        NetworkGetVersionInfoResponse.Builder response = NetworkGetVersionInfoResponse.newBuilder().header(header);
        return Response.newBuilder().networkGetVersionInfo(response).build();
    }

    public void validate(@NonNull QueryContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        Query query = context.query();
        query.networkGetVersionInfoOrThrow();
    }

    public Response findResponse(@NonNull QueryContext context, @NonNull ResponseHeader header) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(header);
        VersionConfig versionConfig = (VersionConfig)context.configuration().getConfigData(VersionConfig.class);
        HederaConfig hederaConfig = (HederaConfig)context.configuration().getConfigData(HederaConfig.class);
        Query query = context.query();
        NetworkGetVersionInfoQuery op = query.networkGetVersionInfoOrThrow();
        NetworkGetVersionInfoResponse.Builder responseBuilder = NetworkGetVersionInfoResponse.newBuilder();
        ResponseType responseType = op.headerOrElse(QueryHeader.DEFAULT).responseType();
        responseBuilder.header(header);
        if (header.nodeTransactionPrecheckCode() == ResponseCodeEnum.OK && responseType != ResponseType.COST_ANSWER) {
            SemanticVersion servicesVersion = hederaConfig.configVersion() == 0 ? versionConfig.servicesVersion() : versionConfig.servicesVersion().copyBuilder().build("" + hederaConfig.configVersion()).build();
            responseBuilder.hederaServicesVersion(servicesVersion).hapiProtoVersion(versionConfig.hapiVersion());
        }
        return Response.newBuilder().networkGetVersionInfo(responseBuilder).build();
    }

    @NonNull
    public Fees computeFees(@NonNull QueryContext queryContext) {
        Objects.requireNonNull(queryContext);
        return queryContext.feeCalculator().legacyCalculate(sigValueObj -> CommonPbjConverters.fromPbj((FeeData)FIXED_USAGE));
    }
}

