/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.networkadmin.impl.handlers;

import com.hedera.hapi.node.base.QueryHeader;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ResponseHeader;
import com.hedera.hapi.node.base.ResponseType;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.hapi.node.transaction.Response;
import com.hedera.hapi.node.transaction.TransactionGetReceiptQuery;
import com.hedera.hapi.node.transaction.TransactionGetReceiptResponse;
import com.hedera.hapi.node.transaction.TransactionReceipt;
import com.hedera.node.app.spi.records.RecordCache;
import com.hedera.node.app.spi.workflows.FreeQueryHandler;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.QueryContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class NetworkTransactionGetReceiptHandler
extends FreeQueryHandler {
    @Inject
    public NetworkTransactionGetReceiptHandler() {
    }

    public QueryHeader extractHeader(@NonNull Query query) {
        Objects.requireNonNull(query);
        return query.transactionGetReceiptOrThrow().header();
    }

    public Response createEmptyResponse(@NonNull ResponseHeader header) {
        Objects.requireNonNull(header);
        TransactionGetReceiptResponse.Builder response = TransactionGetReceiptResponse.newBuilder().header(header);
        return Response.newBuilder().transactionGetReceipt(response).build();
    }

    public void validate(@NonNull QueryContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionGetReceiptQuery op = context.query().transactionGetReceiptOrThrow();
        if (!op.hasTransactionID()) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_TRANSACTION_ID);
        }
        TransactionID transactionId = op.transactionIDOrThrow();
        if (!transactionId.hasTransactionValidStart() || !transactionId.hasAccountID()) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_TRANSACTION_ID);
        }
    }

    public Response findResponse(@NonNull QueryContext context, @NonNull ResponseHeader header) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(header);
        Query query = context.query();
        RecordCache recordCache = context.recordCache();
        TransactionGetReceiptQuery op = query.transactionGetReceiptOrThrow();
        TransactionGetReceiptResponse.Builder responseBuilder = TransactionGetReceiptResponse.newBuilder();
        TransactionID transactionId = op.transactionIDOrThrow();
        responseBuilder.header(header);
        ResponseType responseType = op.headerOrElse(QueryHeader.DEFAULT).responseType();
        if (header.nodeTransactionPrecheckCode() == ResponseCodeEnum.OK && responseType != ResponseType.COST_ANSWER) {
            TransactionID topLevelTxnId = transactionId.nonce() > 0 ? transactionId.copyBuilder().nonce(0).build() : transactionId;
            RecordCache.ReceiptSource receipts = recordCache.getReceipts(topLevelTxnId);
            if (receipts == null) {
                responseBuilder.header(header.copyBuilder().nodeTransactionPrecheckCode(ResponseCodeEnum.RECEIPT_NOT_FOUND).build());
            } else if (transactionId == topLevelTxnId) {
                responseBuilder.receipt(receipts.priorityReceipt(topLevelTxnId));
                if (op.includeDuplicates()) {
                    responseBuilder.duplicateTransactionReceipts(receipts.duplicateReceipts(topLevelTxnId));
                }
                if (op.includeChildReceipts()) {
                    responseBuilder.childTransactionReceipts(receipts.childReceipts(topLevelTxnId));
                }
            } else {
                TransactionReceipt maybeReceipt = receipts.childReceipt(transactionId);
                if (maybeReceipt != null) {
                    responseBuilder.receipt(maybeReceipt);
                } else {
                    responseBuilder.header(header.copyBuilder().nodeTransactionPrecheckCode(ResponseCodeEnum.RECEIPT_NOT_FOUND).build());
                }
            }
        }
        return Response.newBuilder().transactionGetReceipt(responseBuilder).build();
    }
}

