/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.spi;

import com.swirlds.state.spi.FilteredReadableStates;
import com.swirlds.state.spi.WritableKVState;
import com.swirlds.state.spi.WritableQueueState;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Set;

public class FilteredWritableStates
extends FilteredReadableStates
implements WritableStates {
    private final WritableStates delegate;

    public FilteredWritableStates(@NonNull WritableStates delegate, @NonNull Set<Integer> stateIds) {
        super(delegate, stateIds);
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    @NonNull
    public <K, V> WritableKVState<K, V> get(int stateId) {
        if (!this.contains(stateId)) {
            throw new IllegalArgumentException("Could not find k/v state ID " + stateId);
        }
        return this.delegate.get(stateId);
    }

    @Override
    @NonNull
    public <T> WritableSingletonState<T> getSingleton(int stateId) {
        if (!this.contains(stateId)) {
            throw new IllegalArgumentException("Could not find singleton state ID " + stateId);
        }
        return this.delegate.getSingleton(stateId);
    }

    @Override
    @NonNull
    public <E> WritableQueueState<E> getQueue(int stateId) {
        if (!this.contains(stateId)) {
            throw new IllegalArgumentException("Could not find queue state ID " + stateId);
        }
        return this.delegate.getQueue(stateId);
    }

    public WritableStates getDelegate() {
        return this.delegate;
    }
}

