/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.api.internal.format;

import com.swirlds.base.internal.BaseExecutorFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;

public class ShrinkableSizeCache<K, V>
implements Map<K, V> {
    public static final int MAX_ENTRIES = 10000;
    public static final int SHRINK_PERIOD_MS = 1000;
    private final Deque<K> insertionOrderList = new ConcurrentLinkedDeque<K>();
    private final Map<K, V> delegatedMap = new ConcurrentHashMap();

    public ShrinkableSizeCache() {
        this(10000);
    }

    public ShrinkableSizeCache(int maxSize) {
        this(maxSize, 1000);
    }

    public ShrinkableSizeCache(int maxSize, int shrinkPeriodInMs) {
        Runnable cleanUpTask = () -> {
            while (this.insertionOrderList.size() > maxSize) {
                this.delegatedMap.remove(this.insertionOrderList.pop());
            }
            this.afterUpdate();
        };
        BaseExecutorFactory.getInstance().getScheduledExecutor().scheduleAtFixedRate(cleanUpTask, shrinkPeriodInMs, shrinkPeriodInMs, TimeUnit.MILLISECONDS);
    }

    protected void afterUpdate() {
    }

    @Override
    public int size() {
        return this.delegatedMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegatedMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegatedMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegatedMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.delegatedMap.get(key);
    }

    @Override
    public V put(K key, V value) {
        this.delegatedMap.computeIfPresent(key, (k, v) -> value);
        this.delegatedMap.computeIfAbsent(key, k -> {
            this.insertionOrderList.add(k);
            return value;
        });
        return value;
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    @NonNull
    public Set<K> keySet() {
        return new HashSet<K>(this.insertionOrderList);
    }

    @Override
    @NonNull
    public Collection<V> values() {
        return this.delegatedMap.values();
    }

    @Override
    @NonNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegatedMap.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.delegatedMap, this.insertionOrderList);
    }
}

