/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl;

import com.hedera.hapi.node.base.PendingAirdropId;
import com.hedera.hapi.node.state.token.AccountPendingAirdrop;
import com.hedera.node.app.hapi.utils.EntityType;
import com.hedera.node.app.service.token.ReadableAirdropStore;
import com.hedera.node.app.service.token.impl.schemas.V0530TokenSchema;
import com.hedera.node.app.spi.ids.ReadableEntityCounters;
import com.swirlds.state.spi.ReadableKVState;
import com.swirlds.state.spi.ReadableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public class ReadableAirdropStoreImpl
implements ReadableAirdropStore {
    private final ReadableKVState<PendingAirdropId, AccountPendingAirdrop> readableAirdropState;
    private final ReadableEntityCounters entityCounters;

    public ReadableAirdropStoreImpl(@NonNull ReadableStates states, @NonNull ReadableEntityCounters entityCounters) {
        this.entityCounters = entityCounters;
        Objects.requireNonNull(states);
        this.readableAirdropState = states.get(V0530TokenSchema.AIRDROPS_STATE_ID);
    }

    public boolean exists(@NonNull PendingAirdropId airdropId) {
        return this.readableAirdropState.contains((Object)Objects.requireNonNull(airdropId));
    }

    @Nullable
    public AccountPendingAirdrop get(@NonNull PendingAirdropId airdropId) {
        Objects.requireNonNull(airdropId);
        return (AccountPendingAirdrop)this.readableAirdropState.get((Object)airdropId);
    }

    public long sizeOfState() {
        return this.entityCounters.getCounterFor(EntityType.AIRDROP);
    }
}

