/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers.transfer.customfees;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.transaction.AssessedCustomFee;
import com.hedera.node.app.service.token.impl.handlers.transfer.customfees.AssessedFeeWithPayerDebits;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class AssessmentResult {
    public static final TokenID HBAR_TOKEN_ID = TokenID.DEFAULT;
    private final Map<TokenID, Map<AccountID, Long>> htsAdjustments;
    private final Map<AccountID, Long> hbarAdjustments;
    private final Set<Pair<AccountID, TokenID>> royaltiesPaid;
    private final Map<TokenID, Map<AccountID, Long>> immutableInputTokenAdjustments;
    private final Map<TokenID, Map<AccountID, Long>> mutableInputBalanceAdjustments;
    private final Map<AccountID, Long> immutableInputHbarAdjustments;
    private final List<AssessedFeeWithPayerDebits> assessedFeesWithPayerDebits;

    public AssessmentResult(List<TokenTransferList> tokenTransfers, List<AccountAmount> hbarTransfers) {
        this.mutableInputBalanceAdjustments = this.buildFungibleTokenTransferMap(tokenTransfers);
        this.immutableInputTokenAdjustments = Collections.unmodifiableMap(this.mutableInputBalanceAdjustments.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new LinkedHashMap((Map)entry.getValue()), (a, b) -> a, LinkedHashMap::new)));
        this.immutableInputHbarAdjustments = this.buildHbarTransferMap(hbarTransfers);
        this.mutableInputBalanceAdjustments.put(HBAR_TOKEN_ID, new LinkedHashMap<AccountID, Long>(this.immutableInputHbarAdjustments));
        this.htsAdjustments = new LinkedHashMap<TokenID, Map<AccountID, Long>>();
        this.hbarAdjustments = new LinkedHashMap<AccountID, Long>();
        this.royaltiesPaid = new LinkedHashSet<Pair<AccountID, TokenID>>();
        this.assessedFeesWithPayerDebits = new ArrayList<AssessedFeeWithPayerDebits>();
    }

    public Map<TokenID, Map<AccountID, Long>> getImmutableInputTokenAdjustments() {
        return this.immutableInputTokenAdjustments;
    }

    public Map<TokenID, Map<AccountID, Long>> getMutableInputBalanceAdjustments() {
        return this.mutableInputBalanceAdjustments;
    }

    public Map<AccountID, Long> getHbarAdjustments() {
        return this.hbarAdjustments;
    }

    public Map<TokenID, Map<AccountID, Long>> getHtsAdjustments() {
        return this.htsAdjustments;
    }

    public List<AssessedFeeWithPayerDebits> getAssessedFeesWithPayerDebits() {
        return this.assessedFeesWithPayerDebits;
    }

    public void addAssessedFeeWithPayerDebits(@NonNull AssessedCustomFee assessedCustomFee, @NonNull Map<AccountID, Long> multiPayerDeltas) {
        this.assessedFeesWithPayerDebits.add(new AssessedFeeWithPayerDebits(assessedCustomFee, multiPayerDeltas));
    }

    public void addAssessedCustomFee(@NonNull AssessedCustomFee assessedCustomFee) {
        this.assessedFeesWithPayerDebits.add(new AssessedFeeWithPayerDebits(assessedCustomFee, null));
    }

    public Set<Pair<AccountID, TokenID>> getRoyaltiesPaid() {
        return this.royaltiesPaid;
    }

    public void addToRoyaltiesPaid(Pair<AccountID, TokenID> paid) {
        this.royaltiesPaid.add(paid);
    }

    public Map<AccountID, Long> getImmutableInputHbarAdjustments() {
        return this.immutableInputHbarAdjustments;
    }

    private Map<TokenID, Map<AccountID, Long>> buildFungibleTokenTransferMap(List<TokenTransferList> tokenTransfers) {
        LinkedHashMap<TokenID, Map<AccountID, Long>> fungibleTransfersMap = new LinkedHashMap<TokenID, Map<AccountID, Long>>();
        for (TokenTransferList xfer : tokenTransfers) {
            TokenID tokenId = xfer.token();
            List fungibleTokenTransfers = xfer.transfers();
            if (fungibleTokenTransfers.isEmpty()) continue;
            LinkedHashMap<AccountID, Long> tokenTransferMap = new LinkedHashMap<AccountID, Long>();
            for (AccountAmount aa : fungibleTokenTransfers) {
                tokenTransferMap.put(aa.accountID(), aa.amount());
            }
            fungibleTransfersMap.put(tokenId, tokenTransferMap);
        }
        return fungibleTransfersMap;
    }

    private Map<AccountID, Long> buildHbarTransferMap(@NonNull List<AccountAmount> hbarTransfers) {
        LinkedHashMap<AccountID, Long> adjustments = new LinkedHashMap<AccountID, Long>();
        for (AccountAmount aa : hbarTransfers) {
            adjustments.put(aa.accountID(), aa.amount());
        }
        return adjustments;
    }
}

