/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers.transfer.hooks;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HookCall;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.hapi.node.transaction.AssessedCustomFee;
import com.hedera.node.app.hapi.utils.CommonUtils;
import com.hedera.node.app.service.token.AliasUtils;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.impl.handlers.transfer.customfees.AssessedFeeWithPayerDebits;
import com.hedera.node.app.service.token.impl.handlers.transfer.customfees.AssessmentResult;
import com.hedera.node.app.service.token.impl.handlers.transfer.hooks.HookCalls;
import com.hedera.node.app.service.token.impl.handlers.transfer.hooks.HookContext;
import com.hedera.node.app.service.token.impl.handlers.transfer.hooks.HooksABI;
import com.hedera.node.app.spi.workflows.HandleContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.tuweni.bytes.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HookCallFactory {
    private static final Logger log = LoggerFactory.getLogger(HookCallFactory.class);

    @Inject
    public HookCallFactory() {
    }

    public HookCalls from(@NonNull HandleContext handleContext, CryptoTransferTransactionBody userTxn, List<AssessedFeeWithPayerDebits> assessedFeeWithPayerDebits) {
        ReadableAccountStore accountStore = (ReadableAccountStore)handleContext.storeFactory().readableStore(ReadableAccountStore.class);
        String memo = handleContext.body().memo();
        long txnFee = handleContext.body().transactionFee();
        return this.getProposedTransfers(userTxn, accountStore, memo, txnFee, assessedFeeWithPayerDebits);
    }

    private HookCalls getProposedTransfers(CryptoTransferTransactionBody userTxn, ReadableAccountStore accountStore, String memo, long txnFee, List<AssessedFeeWithPayerDebits> assessedFeeWithPayerDebits) {
        ArrayList<HookInvocation> preOnly = new ArrayList<HookInvocation>();
        ArrayList<HookInvocation> prePost = new ArrayList<HookInvocation>();
        Tuple directTransfers = this.encodeTransfers(userTxn.transfersOrElse(TransferList.DEFAULT), userTxn.tokenTransfers(), accountStore, preOnly, prePost);
        Tuple customFeeTransfers = this.encodeCustomFees(accountStore, assessedFeeWithPayerDebits);
        return new HookCalls(new HookContext((Tuple)Tuple.of((Object)directTransfers, (Object)customFeeTransfers), memo, txnFee), preOnly, prePost);
    }

    private Tuple encodeCustomFees(ReadableAccountStore accountStore, List<AssessedFeeWithPayerDebits> assessedFeeWithPayerDebits) {
        if (assessedFeeWithPayerDebits.isEmpty()) {
            return HooksABI.EMPTY_TRANSFERS;
        }
        LinkedHashMap deltas = new LinkedHashMap();
        for (AssessedFeeWithPayerDebits assessedFee : assessedFeeWithPayerDebits) {
            AssessedCustomFee fee = assessedFee.assessedCustomFee();
            TokenID token = fee.hasTokenId() ? fee.tokenIdOrThrow() : AssessmentResult.HBAR_TOKEN_ID;
            Map map = deltas.computeIfAbsent(token, t -> new LinkedHashMap());
            map.merge(fee.feeCollectorAccountIdOrThrow(), fee.amount(), Long::sum);
            if (fee.effectivePayerAccountId().size() == 1) {
                AccountID payer = (AccountID)fee.effectivePayerAccountId().getFirst();
                map.merge(payer, -fee.amount(), Long::sum);
                continue;
            }
            if (assessedFee.multiPayerDeltas() == null) continue;
            for (Map.Entry<AccountID, Long> e : assessedFee.multiPayerDeltas().entrySet()) {
                Long payerDebits = e.getValue();
                map.merge(e.getKey(), payerDebits, Long::sum);
            }
        }
        Map<AccountID, Long> hbarMap = deltas.getOrDefault(AssessmentResult.HBAR_TOKEN_ID, Map.of());
        TransferList hbarTransfers = TransferList.newBuilder().accountAmounts(HookCallFactory.toAccountAmounts(hbarMap)).build();
        List<TokenTransferList> tokenTransfers = deltas.entrySet().stream().filter(en -> !((TokenID)en.getKey()).equals((Object)AssessmentResult.HBAR_TOKEN_ID)).map(en -> TokenTransferList.newBuilder().token((TokenID)en.getKey()).transfers(HookCallFactory.toAccountAmounts((Map)en.getValue())).build()).toList();
        Tuple encoded = this.encodeTransfers(hbarTransfers, tokenTransfers, accountStore, List.of(), List.of());
        return encoded;
    }

    private static List<AccountAmount> toAccountAmounts(Map<AccountID, Long> map) {
        ArrayList<AccountAmount> out = new ArrayList<AccountAmount>(map.size());
        for (Map.Entry<AccountID, Long> e : map.entrySet()) {
            Long amt = e.getValue();
            if (amt == 0L) continue;
            out.add(AccountAmount.newBuilder().accountID(e.getKey()).amount(amt.longValue()).build());
        }
        return out;
    }

    private Tuple encodeTransfers(TransferList hbarTransfers, List<TokenTransferList> tokenTransfersList, ReadableAccountStore accountStore, List<HookInvocation> preOnly, List<HookInvocation> prePost) {
        Tuple[] hbarXfers = this.encodeAccountAmounts(hbarTransfers.accountAmounts(), accountStore, preOnly, prePost);
        Tuple[] tokenTransfers = (Tuple[])tokenTransfersList.stream().map(ttl -> this.encodeTokenTransfers((TokenTransferList)ttl, accountStore, preOnly, prePost)).toArray(Tuple[]::new);
        return Tuple.of((Object)hbarXfers, (Object)tokenTransfers);
    }

    @NonNull
    private Tuple encodeTokenTransfers(TokenTransferList ttl, ReadableAccountStore accounts, List<HookInvocation> preOnly, List<HookInvocation> prePost) {
        Address tokenAddress = HookCallFactory.headlongAddressOf(ttl.tokenOrThrow());
        Tuple[] transfers = this.encodeAccountAmounts(ttl.transfers(), accounts, preOnly, prePost);
        Tuple[] nftTransfers = this.encodeNftTransfers(ttl.nftTransfers(), accounts, preOnly, prePost);
        return Tuple.of((Object)tokenAddress, (Object)transfers, (Object)nftTransfers);
    }

    private Tuple[] encodeNftTransfers(List<NftTransfer> nftTransfers, ReadableAccountStore accounts, List<HookInvocation> preOnly, List<HookInvocation> prePost) {
        return (Tuple[])nftTransfers.stream().map(nft -> {
            HookCall hook;
            Address sender = HookCallFactory.resolveAccountAddress(accounts, nft.senderAccountIDOrThrow());
            Address receiver = HookCallFactory.resolveAccountAddress(accounts, nft.receiverAccountIDOrThrow());
            if (nft.hasPreTxSenderAllowanceHook()) {
                hook = nft.preTxSenderAllowanceHookOrThrow();
                preOnly.add(new HookInvocation(nft.senderAccountID(), hook.hookIdOrThrow(), sender, hook.evmHookCallOrThrow().data(), hook.evmHookCallOrThrow().gasLimit()));
            }
            if (nft.hasPrePostTxSenderAllowanceHook()) {
                hook = nft.prePostTxSenderAllowanceHookOrThrow();
                prePost.add(new HookInvocation(nft.senderAccountID(), hook.hookIdOrThrow(), sender, hook.evmHookCallOrThrow().data(), hook.evmHookCallOrThrow().gasLimit()));
            }
            if (nft.hasPreTxReceiverAllowanceHook()) {
                hook = nft.preTxReceiverAllowanceHookOrThrow();
                preOnly.add(new HookInvocation(nft.receiverAccountID(), hook.hookIdOrThrow(), receiver, hook.evmHookCallOrThrow().data(), hook.evmHookCallOrThrow().gasLimit()));
            }
            if (nft.hasPrePostTxReceiverAllowanceHook()) {
                hook = nft.prePostTxReceiverAllowanceHookOrThrow();
                prePost.add(new HookInvocation(nft.receiverAccountID(), hook.hookIdOrThrow(), receiver, hook.evmHookCallOrThrow().data(), hook.evmHookCallOrThrow().gasLimit()));
            }
            long serialNum = nft.serialNumber();
            return Tuple.of((Object)sender, (Object)receiver, (Object)serialNum);
        }).toArray(Tuple[]::new);
    }

    private Tuple[] encodeAccountAmounts(List<AccountAmount> items, ReadableAccountStore accountStore, List<HookInvocation> preOnly, List<HookInvocation> prePost) {
        return (Tuple[])items.stream().map(aa -> {
            HookCall hook;
            Address address = HookCallFactory.resolveAccountAddress(accountStore, aa.accountIDOrThrow());
            long amount = aa.amount();
            if (aa.hasPreTxAllowanceHook()) {
                hook = aa.preTxAllowanceHookOrThrow();
                preOnly.add(new HookInvocation(aa.accountID(), hook.hookIdOrThrow(), address, hook.evmHookCallOrThrow().data(), hook.evmHookCallOrThrow().gasLimit()));
            }
            if (aa.hasPrePostTxAllowanceHook()) {
                hook = aa.prePostTxAllowanceHookOrThrow();
                prePost.add(new HookInvocation(aa.accountID(), hook.hookIdOrThrow(), address, hook.evmHookCallOrThrow().data(), hook.evmHookCallOrThrow().gasLimit()));
            }
            return Tuple.of((Object)address, (Object)amount);
        }).toArray(Tuple[]::new);
    }

    private static Address resolveAccountAddress(ReadableAccountStore accountStore, AccountID ownerId) {
        Account owner = accountStore.getAccountById(ownerId);
        return HookCallFactory.priorityAddressOf(Objects.requireNonNull(owner));
    }

    private static Address priorityAddressOf(@NonNull Account account) {
        Objects.requireNonNull(account);
        return HookCallFactory.asHeadlongAddress(HookCallFactory.explicitAddressOf(account));
    }

    public static Address asHeadlongAddress(@NonNull byte[] explicit) {
        Objects.requireNonNull(explicit);
        BigInteger integralAddress = Bytes.wrap((byte[])explicit).toUnsignedBigInteger();
        return Address.wrap((String)Address.toChecksumAddress((BigInteger)integralAddress));
    }

    private static byte[] explicitAddressOf(@NonNull Account account) {
        Objects.requireNonNull(account);
        com.hedera.pbj.runtime.io.buffer.Bytes evmAddress = AliasUtils.extractEvmAddress((com.hedera.pbj.runtime.io.buffer.Bytes)account.alias());
        return evmAddress != null ? evmAddress.toByteArray() : CommonUtils.asEvmAddress((long)account.accountIdOrThrow().accountNumOrThrow());
    }

    public static Address headlongAddressOf(@NonNull TokenID tokenId) {
        Objects.requireNonNull(tokenId);
        return HookCallFactory.asHeadlongAddress(CommonUtils.asEvmAddress((long)tokenId.tokenNum()));
    }

    public record HookInvocation(AccountID ownerId, long hookId, Address ownerAddress, com.hedera.pbj.runtime.io.buffer.Bytes calldata, long gasLimit) {
    }
}

