/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.validators;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.token.TokenUpdateTransactionBody;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.service.token.impl.util.TokenHandlerHelper;
import com.hedera.node.app.service.token.impl.validators.TokenAttributesValidator;
import com.hedera.node.app.spi.store.StoreFactory;
import com.hedera.node.app.spi.validation.ExpiryMeta;
import com.hedera.node.app.spi.validation.ExpiryValidator;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.config.data.TokensConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import javax.inject.Inject;

public class TokenUpdateValidator {
    private final TokenAttributesValidator validator;

    @Inject
    public TokenUpdateValidator(@NonNull TokenAttributesValidator validator) {
        this.validator = validator;
    }

    @NonNull
    public ValidationResult validateSemantics(@NonNull HandleContext context, @NonNull TokenUpdateTransactionBody op) {
        StoreFactory storeFactory = context.storeFactory();
        ReadableAccountStore readableAccountStore = (ReadableAccountStore)storeFactory.readableStore(ReadableAccountStore.class);
        ReadableTokenStore tokenStore = (ReadableTokenStore)storeFactory.readableStore(ReadableTokenStore.class);
        Token token = TokenHandlerHelper.getIfUsable(op.tokenOrThrow(), tokenStore);
        TokensConfig tokensConfig = (TokensConfig)context.configuration().getConfigData(TokensConfig.class);
        if (op.hasMemo()) {
            context.attributeValidator().validateMemo(op.memo());
        }
        if (op.hasMetadata()) {
            this.validator.validateTokenMetadata(op.metadataOrThrow(), tokensConfig);
        }
        if (!op.symbol().isEmpty()) {
            this.validator.validateTokenSymbol(op.symbol(), tokensConfig);
        }
        if (!op.name().isEmpty()) {
            this.validator.validateTokenName(op.name(), tokensConfig);
        }
        if (!(op.hasExpiry() || op.hasAutoRenewPeriod() || op.hasAutoRenewAccount())) {
            return new ValidationResult(token, new ExpiryMeta(token.expirationSecond(), token.autoRenewSeconds(), token.autoRenewAccountId()));
        }
        ExpiryMeta resolvedExpiryMeta = this.resolveExpiry(token, op, context.expiryValidator());
        if (op.hasAutoRenewAccount()) {
            this.validateNewAndExistingAutoRenewAccount(resolvedExpiryMeta.autoRenewAccountId(), token.autoRenewAccountId(), readableAccountStore, context.expiryValidator());
        }
        return new ValidationResult(token, resolvedExpiryMeta);
    }

    private void validateNewAndExistingAutoRenewAccount(AccountID resolvedAutoRenewId, AccountID existingAutoRenewId, ReadableAccountStore readableAccountStore, ExpiryValidator expiryValidator) {
        TokenHandlerHelper.getIfUsable(resolvedAutoRenewId, readableAccountStore, expiryValidator, ResponseCodeEnum.INVALID_AUTORENEW_ACCOUNT);
        if (!resolvedAutoRenewId.equals((Object)AccountID.DEFAULT) && existingAutoRenewId != null) {
            TokenHandlerHelper.getIfUsable(existingAutoRenewId, readableAccountStore, expiryValidator, ResponseCodeEnum.INVALID_AUTORENEW_ACCOUNT);
        }
    }

    private ExpiryMeta resolveExpiry(@NonNull Token token, @NonNull TokenUpdateTransactionBody op, @NonNull ExpiryValidator expiryValidator) {
        ExpiryMeta givenExpiryMeta = new ExpiryMeta(token.expirationSecond(), token.autoRenewSeconds(), token.autoRenewAccountId());
        ExpiryMeta updateExpiryMeta = new ExpiryMeta(op.hasExpiry() ? op.expiryOrThrow().seconds() : ExpiryMeta.NA, op.hasAutoRenewPeriod() ? op.autoRenewPeriodOrThrow().seconds() : ExpiryMeta.NA, op.autoRenewAccount());
        return expiryValidator.resolveUpdateAttempt(givenExpiryMeta, updateExpiryMeta);
    }

    public record ValidationResult(@NonNull Token token, @NonNull ExpiryMeta resolvedExpiryMeta) {
    }
}

