/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.fees.usage.crypto;

import com.hedera.node.app.hapi.fees.usage.BaseTransactionMeta;
import com.hedera.node.app.hapi.fees.usage.EstimatorFactory;
import com.hedera.node.app.hapi.fees.usage.QueryUsage;
import com.hedera.node.app.hapi.fees.usage.SigUsage;
import com.hedera.node.app.hapi.fees.usage.SingletonEstimatorUtils;
import com.hedera.node.app.hapi.fees.usage.SingletonUsageProperties;
import com.hedera.node.app.hapi.fees.usage.TxnUsageEstimator;
import com.hedera.node.app.hapi.fees.usage.crypto.CryptoApproveAllowanceMeta;
import com.hedera.node.app.hapi.fees.usage.crypto.CryptoContextUtils;
import com.hedera.node.app.hapi.fees.usage.crypto.CryptoCreateMeta;
import com.hedera.node.app.hapi.fees.usage.crypto.CryptoDeleteAllowanceMeta;
import com.hedera.node.app.hapi.fees.usage.crypto.CryptoTransferMeta;
import com.hedera.node.app.hapi.fees.usage.crypto.CryptoUpdateMeta;
import com.hedera.node.app.hapi.fees.usage.crypto.ExtantCryptoContext;
import com.hedera.node.app.hapi.fees.usage.crypto.entities.CryptoEntitySizes;
import com.hedera.node.app.hapi.fees.usage.state.UsageAccumulator;
import com.hedera.node.app.hapi.fees.usage.token.entities.TokenEntitySizes;
import com.hedera.node.app.hapi.utils.fee.FeeBuilder;
import com.hederahashgraph.api.proto.java.CryptoGetInfoQuery;
import com.hederahashgraph.api.proto.java.FeeData;
import com.hederahashgraph.api.proto.java.GetAccountDetailsQuery;
import com.hederahashgraph.api.proto.java.Key;
import com.hederahashgraph.api.proto.java.Query;
import com.hederahashgraph.api.proto.java.ResponseType;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CryptoOpsUsage {
    private static final long LONG_BASIC_ENTITY_ID_SIZE = 24L;
    public static final long LONG_ACCOUNT_AMOUNT_BYTES = SingletonUsageProperties.USAGE_PROPERTIES.accountAmountBytes();
    public static final long CREATE_SLOT_MULTIPLIER = 1228L;
    public static final long UPDATE_SLOT_MULTIPLIER = 24000L;
    public static final long HOUR_TO_SECOND_MULTIPLIER = 3600L;
    public static EstimatorFactory txnEstimateFactory = TxnUsageEstimator::new;
    static Function<ResponseType, QueryUsage> queryEstimateFactory = QueryUsage::new;

    @Inject
    public CryptoOpsUsage() {
    }

    public void cryptoTransferUsage(SigUsage sigUsage, CryptoTransferMeta xferMeta, BaseTransactionMeta baseMeta, UsageAccumulator accumulator, long hookGasLimit, boolean usesHooks) {
        accumulator.resetForTransaction(baseMeta, sigUsage);
        if (usesHooks) {
            accumulator.addGas(hookGasLimit);
            accumulator.addSbs(3600L);
            accumulator.addVpt(Math.max(0, sigUsage.numSigs() - 1));
        } else {
            int tokenMultiplier = xferMeta.getTokenMultiplier();
            int totalXfers = baseMeta.numExplicitTransfers();
            int weightedTokensInvolved = tokenMultiplier * xferMeta.getNumTokensInvolved();
            int weightedTokenXfers = tokenMultiplier * xferMeta.getNumFungibleTokenTransfers();
            long incBpt = (long)weightedTokensInvolved * 24L;
            incBpt += (long)(weightedTokenXfers + totalXfers) * LONG_ACCOUNT_AMOUNT_BYTES;
            accumulator.addBpt(incBpt += TokenEntitySizes.TOKEN_ENTITY_SIZES.bytesUsedForUniqueTokenTransfers(xferMeta.getNumNftOwnershipChanges()));
            long incRb = (long)(totalXfers += xferMeta.getCustomFeeHbarTransfers()) * LONG_ACCOUNT_AMOUNT_BYTES;
            accumulator.addRbs((incRb += (long)TokenEntitySizes.TOKEN_ENTITY_SIZES.bytesUsedToRecordTokenTransfers(weightedTokensInvolved += tokenMultiplier * xferMeta.getCustomFeeTokensInvolved(), weightedTokenXfers += tokenMultiplier * xferMeta.getCustomFeeTokenTransfers(), xferMeta.getNumNftOwnershipChanges())) * SingletonUsageProperties.USAGE_PROPERTIES.legacyReceiptStorageSecs());
        }
    }

    public FeeData cryptoInfoUsage(Query cryptoInfoReq, ExtantCryptoContext ctx) {
        CryptoGetInfoQuery op = cryptoInfoReq.getCryptoGetInfo();
        QueryUsage estimate = queryEstimateFactory.apply(op.getHeader().getResponseType());
        return this.getUsage(estimate, ctx);
    }

    public FeeData accountDetailsUsage(Query accountDetailsReq, ExtantCryptoContext ctx) {
        GetAccountDetailsQuery op = accountDetailsReq.getAccountDetails();
        QueryUsage estimate = queryEstimateFactory.apply(op.getHeader().getResponseType());
        return this.getUsage(estimate, ctx);
    }

    private FeeData getUsage(QueryUsage estimate, ExtantCryptoContext ctx) {
        estimate.addTb(24L);
        long extraRb = 0L;
        extraRb += (long)ctx.currentMemo().getBytes(StandardCharsets.UTF_8).length;
        extraRb += (long)FeeBuilder.getAccountKeyStorageSize((Key)ctx.currentKey());
        if (ctx.currentlyHasProxy()) {
            extraRb += 24L;
        }
        estimate.addRb((long)CryptoEntitySizes.CRYPTO_ENTITY_SIZES.fixedBytesInAccountRepr() + (extraRb += (long)(ctx.currentNumTokenRels() * TokenEntitySizes.TOKEN_ENTITY_SIZES.bytesUsedPerAccountRelationship())));
        return estimate.get();
    }

    public long cryptoAutoRenewRb(ExtantCryptoContext ctx) {
        return (long)CryptoEntitySizes.CRYPTO_ENTITY_SIZES.fixedBytesInAccountRepr() + ctx.currentNonBaseRb() + (long)ctx.currentNumTokenRels() * CryptoEntitySizes.CRYPTO_ENTITY_SIZES.bytesInTokenAssocRepr();
    }

    public void cryptoUpdateUsage(SigUsage sigUsage, BaseTransactionMeta baseMeta, CryptoUpdateMeta cryptoUpdateMeta, ExtantCryptoContext ctx, UsageAccumulator accumulator, long explicitAutoAssocSlotLifetime) {
        accumulator.resetForTransaction(baseMeta, sigUsage);
        accumulator.addBpt(cryptoUpdateMeta.getMsgBytesUsed());
        long newVariableBytes = 0L;
        long newMemoSize = cryptoUpdateMeta.getMemoSize();
        newVariableBytes += newMemoSize != 0L ? newMemoSize : (long)ctx.currentMemo().getBytes(StandardCharsets.UTF_8).length;
        long newKeyBytes = cryptoUpdateMeta.getKeyBytesUsed();
        newVariableBytes += newKeyBytes == 0L ? (long)FeeBuilder.getAccountKeyStorageSize((Key)ctx.currentKey()) : newKeyBytes;
        long l = cryptoUpdateMeta.hasProxy() || ctx.currentlyHasProxy() ? 24L : 0L;
        long tokenRelBytes = (long)ctx.currentNumTokenRels() * CryptoEntitySizes.CRYPTO_ENTITY_SIZES.bytesInTokenAssocRepr();
        long sharedFixedBytes = (long)CryptoEntitySizes.CRYPTO_ENTITY_SIZES.fixedBytesInAccountRepr() + tokenRelBytes;
        long newLifetime = SingletonEstimatorUtils.ESTIMATOR_UTILS.relativeLifetime(cryptoUpdateMeta.getEffectiveNow(), cryptoUpdateMeta.getExpiry());
        long oldLifetime = SingletonEstimatorUtils.ESTIMATOR_UTILS.relativeLifetime(cryptoUpdateMeta.getEffectiveNow(), ctx.currentExpiry());
        long rbsDelta = SingletonEstimatorUtils.ESTIMATOR_UTILS.changeInBsUsage(this.cryptoAutoRenewRb(ctx), oldLifetime, sharedFixedBytes + (newVariableBytes += l), newLifetime);
        if (rbsDelta > 0L) {
            accumulator.addRbs(rbsDelta);
        }
        long oldSlotsUsage = (long)ctx.currentMaxAutomaticAssociations() * 24000L;
        long newSlotsUsage = cryptoUpdateMeta.hasMaxAutomaticAssociations() ? (long)cryptoUpdateMeta.getMaxAutomaticAssociations() * 24000L : oldSlotsUsage;
        long slotRbsDelta = SingletonEstimatorUtils.ESTIMATOR_UTILS.changeInBsUsage(oldSlotsUsage, Math.max(explicitAutoAssocSlotLifetime, oldLifetime), newSlotsUsage, Math.max(explicitAutoAssocSlotLifetime, newLifetime));
        if (slotRbsDelta > 0L) {
            accumulator.addRbs(slotRbsDelta);
        }
        if (cryptoUpdateMeta.getNumHookCreations() > 0 || cryptoUpdateMeta.getNumHookDeletions() > 0) {
            accumulator.addSbs((long)(cryptoUpdateMeta.getNumHookCreations() + cryptoUpdateMeta.getNumHookDeletions()) * 3600L);
        }
    }

    public void cryptoCreateUsage(SigUsage sigUsage, BaseTransactionMeta baseMeta, CryptoCreateMeta cryptoCreateMeta, UsageAccumulator accumulator) {
        accumulator.resetForTransaction(baseMeta, sigUsage);
        long baseSize = cryptoCreateMeta.getBaseSize();
        int maxAutomaticTokenAssociations = cryptoCreateMeta.getMaxAutomaticAssociations();
        long lifeTime = cryptoCreateMeta.getLifeTime();
        if (maxAutomaticTokenAssociations > 0) {
            baseSize += 4L;
        }
        accumulator.addBpt(baseSize + 16L + 4L);
        accumulator.addRbs(((long)CryptoEntitySizes.CRYPTO_ENTITY_SIZES.fixedBytesInAccountRepr() + baseSize) * lifeTime);
        accumulator.addNetworkRbs(24L * SingletonUsageProperties.USAGE_PROPERTIES.legacyReceiptStorageSecs());
        if (cryptoCreateMeta.getNumHooks() > 0L) {
            accumulator.addSbs(cryptoCreateMeta.getNumHooks() * 3600L);
        }
    }

    public void cryptoApproveAllowanceUsage(SigUsage sigUsage, BaseTransactionMeta baseMeta, CryptoApproveAllowanceMeta cryptoApproveMeta, ExtantCryptoContext ctx, UsageAccumulator accumulator) {
        accumulator.resetForTransaction(baseMeta, sigUsage);
        accumulator.addBpt(cryptoApproveMeta.getMsgBytesUsed());
        long lifeTime = SingletonEstimatorUtils.ESTIMATOR_UTILS.relativeLifetime(cryptoApproveMeta.getEffectiveNow(), ctx.currentExpiry());
        long adjustedBytes = this.getNewBytes(cryptoApproveMeta, ctx);
        if (adjustedBytes > 0L) {
            accumulator.addRbs(adjustedBytes * lifeTime);
        }
    }

    public void cryptoDeleteAllowanceUsage(SigUsage sigUsage, BaseTransactionMeta baseMeta, CryptoDeleteAllowanceMeta cryptoDeleteAllowanceMeta, UsageAccumulator accumulator) {
        accumulator.resetForTransaction(baseMeta, sigUsage);
        accumulator.addBpt(cryptoDeleteAllowanceMeta.getMsgBytesUsed());
    }

    private long getNewBytes(CryptoApproveAllowanceMeta cryptoApproveMeta, ExtantCryptoContext ctx) {
        long newTotalBytes = 0L;
        newTotalBytes += (long)(cryptoApproveMeta.getCryptoAllowancesCount() * 36);
        int newTokenKeys = CryptoContextUtils.getChangedTokenKeys(cryptoApproveMeta.getTokenAllowances().keySet(), ctx.currentTokenAllowances().keySet());
        newTotalBytes += (long)(newTokenKeys * 40);
        int newApproveForAllNfts = CryptoContextUtils.getChangedTokenKeys(cryptoApproveMeta.getNftAllowances(), ctx.currentNftAllowances());
        return newTotalBytes += (long)(newApproveForAllNfts * 36);
    }
}

