/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.fees.usage.token;

import com.hedera.node.app.hapi.fees.usage.SingletonEstimatorUtils;
import com.hedera.node.app.hapi.fees.usage.TxnUsageEstimator;
import com.hedera.node.app.hapi.fees.usage.token.TokenTxnUsage;
import com.hedera.node.app.hapi.utils.fee.FeeBuilder;
import com.hederahashgraph.api.proto.java.AccountID;
import com.hederahashgraph.api.proto.java.FeeData;
import com.hederahashgraph.api.proto.java.Key;
import com.hederahashgraph.api.proto.java.TokenUpdateTransactionBody;
import com.hederahashgraph.api.proto.java.TransactionBody;
import java.util.Optional;

public class TokenUpdateUsage
extends TokenTxnUsage<TokenUpdateUsage> {
    private int currentMemoLen;
    private int currentNameLen;
    private int currentSymbolLen;
    private long currentExpiry;
    private long currentMutableRb = 0L;
    private boolean currentlyUsingAutoRenew = false;

    private TokenUpdateUsage(TransactionBody tokenUpdateOp, TxnUsageEstimator usageEstimator) {
        super(tokenUpdateOp, usageEstimator);
    }

    public static TokenUpdateUsage newEstimate(TransactionBody tokenUpdateOp, TxnUsageEstimator usageEstimator) {
        return new TokenUpdateUsage(tokenUpdateOp, usageEstimator);
    }

    @Override
    TokenUpdateUsage self() {
        return this;
    }

    public TokenUpdateUsage givenCurrentAdminKey(Optional<Key> adminKey) {
        adminKey.map(FeeBuilder::getAccountKeyStorageSize).ifPresent(this::updateCurrentRb);
        return this;
    }

    public TokenUpdateUsage givenCurrentWipeKey(Optional<Key> wipeKey) {
        wipeKey.map(FeeBuilder::getAccountKeyStorageSize).ifPresent(this::updateCurrentRb);
        return this;
    }

    public TokenUpdateUsage givenCurrentSupplyKey(Optional<Key> supplyKey) {
        supplyKey.map(FeeBuilder::getAccountKeyStorageSize).ifPresent(this::updateCurrentRb);
        return this;
    }

    public TokenUpdateUsage givenCurrentFreezeKey(Optional<Key> freezeKey) {
        freezeKey.map(FeeBuilder::getAccountKeyStorageSize).ifPresent(this::updateCurrentRb);
        return this;
    }

    public TokenUpdateUsage givenCurrentKycKey(Optional<Key> kycKey) {
        kycKey.map(FeeBuilder::getAccountKeyStorageSize).ifPresent(this::updateCurrentRb);
        return this;
    }

    public TokenUpdateUsage givenCurrentFeeScheduleKey(Optional<Key> feeScheduleKey) {
        feeScheduleKey.map(FeeBuilder::getAccountKeyStorageSize).ifPresent(this::updateCurrentRb);
        return this;
    }

    public TokenUpdateUsage givenCurrentPauseKey(Optional<Key> pauseKey) {
        pauseKey.map(FeeBuilder::getAccountKeyStorageSize).ifPresent(this::updateCurrentRb);
        return this;
    }

    public TokenUpdateUsage givenCurrentMemo(String memo) {
        this.currentMemoLen = memo.length();
        this.updateCurrentRb(this.currentMemoLen);
        return this;
    }

    public TokenUpdateUsage givenCurrentName(String name) {
        this.currentNameLen = name.length();
        this.updateCurrentRb(this.currentNameLen);
        return this;
    }

    public TokenUpdateUsage givenCurrentSymbol(String symbol) {
        this.currentSymbolLen = symbol.length();
        this.updateCurrentRb(this.currentSymbolLen);
        return this;
    }

    public TokenUpdateUsage givenCurrentlyUsingAutoRenewAccount() {
        this.currentlyUsingAutoRenew = true;
        this.updateCurrentRb(24L);
        return this;
    }

    public TokenUpdateUsage givenCurrentExpiry(long expiry) {
        this.currentExpiry = expiry;
        return this;
    }

    public FeeData get() {
        TokenUpdateTransactionBody op = this.op.getTokenUpdate();
        long newMutableRb = 0L;
        newMutableRb += TokenUpdateUsage.keySizeIfPresent(op, TokenUpdateTransactionBody::hasKycKey, TokenUpdateTransactionBody::getKycKey);
        newMutableRb += TokenUpdateUsage.keySizeIfPresent(op, TokenUpdateTransactionBody::hasWipeKey, TokenUpdateTransactionBody::getWipeKey);
        newMutableRb += TokenUpdateUsage.keySizeIfPresent(op, TokenUpdateTransactionBody::hasAdminKey, TokenUpdateTransactionBody::getAdminKey);
        newMutableRb += TokenUpdateUsage.keySizeIfPresent(op, TokenUpdateTransactionBody::hasSupplyKey, TokenUpdateTransactionBody::getSupplyKey);
        newMutableRb += TokenUpdateUsage.keySizeIfPresent(op, TokenUpdateTransactionBody::hasFreezeKey, TokenUpdateTransactionBody::getFreezeKey);
        newMutableRb += TokenUpdateUsage.keySizeIfPresent(op, TokenUpdateTransactionBody::hasPauseKey, TokenUpdateTransactionBody::getPauseKey);
        if (!this.removesAutoRenewAccount(op) && (this.currentlyUsingAutoRenew || op.hasAutoRenewAccount())) {
            newMutableRb += 24L;
        }
        newMutableRb += op.hasMemo() ? (long)op.getMemo().getValue().length() : (long)this.currentMemoLen;
        newMutableRb += op.getName().length() > 0 ? (long)op.getName().length() : (long)this.currentNameLen;
        long l = op.getSymbol().length() > 0 ? (long)op.getSymbol().length() : (long)this.currentSymbolLen;
        long newLifetime = SingletonEstimatorUtils.ESTIMATOR_UTILS.relativeLifetime(this.op, Math.max(op.getExpiry().getSeconds(), this.currentExpiry));
        long rbsDelta = Math.max(0L, (newLifetime = Math.min(newLifetime, 3153600000L)) * ((newMutableRb += l) - this.currentMutableRb));
        if (rbsDelta > 0L) {
            this.usageEstimator.addRbs(rbsDelta);
        }
        long txnBytes = newMutableRb + 24L + (long)this.noRbImpactBytes(op);
        this.usageEstimator.addBpt(txnBytes);
        if (op.hasTreasury()) {
            this.addTokenTransfersRecordRb(1, 2, 0);
        }
        return this.usageEstimator.get();
    }

    private int noRbImpactBytes(TokenUpdateTransactionBody op) {
        return (op.getExpiry().getSeconds() > 0L ? 8 : 0) + (op.getAutoRenewPeriod().getSeconds() > 0L ? 8 : 0) + (op.hasTreasury() ? 24 : 0) + (op.hasAutoRenewAccount() ? 24 : 0);
    }

    private boolean removesAutoRenewAccount(TokenUpdateTransactionBody op) {
        return op.hasAutoRenewAccount() && this.designatesAccountRemoval(op.getAutoRenewAccount());
    }

    private boolean designatesAccountRemoval(AccountID id) {
        return id.getShardNum() == 0L && id.getRealmNum() == 0L && id.getAccountNum() == 0L && id.getAlias().isEmpty();
    }

    private void updateCurrentRb(long amount) {
        this.currentMutableRb += amount;
    }
}

