/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.block.stream.trace.codec;

import com.hedera.hapi.block.stream.trace.SlotRead;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class SlotReadJsonCodec
implements JsonCodec<SlotRead> {
    public static final OneOf<SlotRead.IdentifierOneOfType> IDENTIFIER_UNSET = new OneOf((Enum)SlotRead.IdentifierOneOfType.UNSET, null);

    @NonNull
    public SlotRead parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            OneOf temp_identifier = IDENTIFIER_UNSET;
            Bytes temp_read_value = Bytes.EMPTY;
            block12: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "index": {
                        temp_identifier = new OneOf((Enum)SlotRead.IdentifierOneOfType.INDEX, (Object)JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value()));
                        continue block12;
                    }
                    case "key": {
                        temp_identifier = new OneOf((Enum)SlotRead.IdentifierOneOfType.KEY, (Object)Bytes.fromBase64((String)kvPair.value().STRING().getText()));
                        continue block12;
                    }
                    case "readValue": {
                        temp_read_value = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block12;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new SlotRead(temp_identifier, temp_read_value);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull SlotRead data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.identifier().kind() == SlotRead.IdentifierOneOfType.INDEX) {
            fieldLines.add(JsonTools.field((String)"index", (Integer)data.index()));
        }
        if (data.identifier().kind() == SlotRead.IdentifierOneOfType.KEY) {
            fieldLines.add(JsonTools.field((String)"key", (Bytes)data.key()));
        }
        if (data.readValue() != Bytes.EMPTY && data.readValue() != null && data.readValue().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"readValue", (Bytes)data.readValue()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

