/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.roster.codec;

import com.hedera.hapi.node.state.roster.RoundRosterPair;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class RoundRosterPairJsonCodec
implements JsonCodec<RoundRosterPair> {
    @NonNull
    public RoundRosterPair parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            long temp_round_number = 0L;
            Bytes temp_active_roster_hash = Bytes.EMPTY;
            block10: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "roundNumber": {
                        temp_round_number = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block10;
                    }
                    case "activeRosterHash": {
                        temp_active_roster_hash = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block10;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new RoundRosterPair(temp_round_number, temp_active_roster_hash);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull RoundRosterPair data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.roundNumber() != 0L) {
            fieldLines.add(JsonTools.field((String)"roundNumber", (long)data.roundNumber()));
        }
        if (data.activeRosterHash() != Bytes.EMPTY && data.activeRosterHash() != null && data.activeRosterHash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"activeRosterHash", (Bytes)data.activeRosterHash()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

