/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.event.report;

import com.swirlds.common.formatting.StringFormattingUtils;
import com.swirlds.common.formatting.TextEffect;
import com.swirlds.common.formatting.UnitFormatter;
import com.swirlds.common.io.IOIterator;
import com.swirlds.common.units.TimeUnit;
import com.swirlds.platform.event.report.EventStreamInfo;
import com.swirlds.platform.event.report.EventStreamReport;
import com.swirlds.platform.recovery.internal.EventStreamLowerBound;
import com.swirlds.platform.recovery.internal.EventStreamMultiFileIterator;
import com.swirlds.platform.recovery.internal.MultiFileRunningHashIterator;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.hiero.base.CompareTo;
import org.hiero.consensus.model.event.CesEvent;

public class EventStreamScanner {
    private static final int PROGRESS_INTERVAL = 10000;
    private long eventCount = 0L;
    private long applicationTransactionCount = 0L;
    private final List<EventStreamInfo> granularInfo = new ArrayList<EventStreamInfo>();
    private CesEvent granularFirstEvent;
    private long granularStartingFileCount = 0L;
    private long previousFileCount = 0L;
    private long previousDamagedFileCount = 0L;
    private long previousByteCount = 0L;
    private long granularStartingDamagedFileCount = 0L;
    private long granularEventCount = 0L;
    private long granularApplicationTransactionCount = 0L;
    private final Duration reportPeriod;
    private final boolean enableProgressReport;
    private final EventStreamMultiFileIterator fileIterator;
    private final IOIterator<CesEvent> eventIterator;

    public EventStreamScanner(@NonNull Path eventStreamDirectory, @NonNull EventStreamLowerBound lowerBound, @NonNull Duration reportPeriod, boolean enableProgressReport) throws IOException {
        Objects.requireNonNull(eventStreamDirectory, "the event stream directory must not be null");
        Objects.requireNonNull(lowerBound, "the lower bound must not be null");
        this.reportPeriod = Objects.requireNonNull(reportPeriod, "the report period must not be null");
        this.enableProgressReport = enableProgressReport;
        this.fileIterator = new EventStreamMultiFileIterator(eventStreamDirectory, lowerBound);
        this.eventIterator = new MultiFileRunningHashIterator(this.fileIterator);
    }

    private void reportGranularData(CesEvent lastEventInPeriod) {
        long granularRoundCount = lastEventInPeriod.getRoundReceived() - this.granularFirstEvent.getRoundReceived();
        this.granularInfo.add(new EventStreamInfo(this.granularFirstEvent.getPlatformEvent().getConsensusTimestamp(), lastEventInPeriod.getPlatformEvent().getConsensusTimestamp(), granularRoundCount, this.granularEventCount, this.granularApplicationTransactionCount, this.previousFileCount - this.granularStartingFileCount, this.fileIterator.getBytesRead() - this.previousByteCount, this.granularFirstEvent, lastEventInPeriod, this.previousDamagedFileCount - this.granularStartingDamagedFileCount));
    }

    private void resetGranularData(CesEvent mostRecentEvent) {
        this.granularFirstEvent = mostRecentEvent;
        this.granularEventCount = 0L;
        this.granularApplicationTransactionCount = 0L;
        this.granularStartingFileCount = this.fileIterator.getFileCount();
        this.granularStartingDamagedFileCount = this.fileIterator.getDamagedFileCount();
        this.previousByteCount = this.fileIterator.getBytesRead();
    }

    private void collectEventData(CesEvent mostRecentEvent) {
        ++this.eventCount;
        ++this.granularEventCount;
        mostRecentEvent.getPlatformEvent().transactionIterator().forEachRemaining(transaction -> {
            ++this.applicationTransactionCount;
            ++this.granularApplicationTransactionCount;
        });
    }

    private void writeConsoleSummary(CesEvent firstEvent, CesEvent mostRecentEvent) {
        if (this.enableProgressReport && this.eventCount % 10000L == 0L) {
            Duration consensusTimeProcessed = Duration.between(firstEvent.getPlatformEvent().getConsensusTimestamp(), mostRecentEvent.getPlatformEvent().getConsensusTimestamp());
            UnitFormatter formatter = TimeUnit.UNIT_MILLISECONDS.buildFormatter().setQuantity(consensusTimeProcessed.toMillis()).setDecimalPlaces(2).setAbbreviate(false);
            System.out.print(" > " + TextEffect.BRIGHT_RED.apply(StringFormattingUtils.commaSeparatedNumber((long)this.eventCount)) + " events have been parsed from a consensus timespan of " + TextEffect.BRIGHT_YELLOW.apply(formatter.render()) + "             \r");
            System.out.flush();
        }
    }

    public EventStreamReport createReport() throws IOException {
        CesEvent firstEvent;
        if (!this.eventIterator.hasNext()) {
            throw new IllegalStateException("No events found in the event stream");
        }
        this.granularFirstEvent = firstEvent = (CesEvent)this.eventIterator.peek();
        CesEvent mostRecentEvent = null;
        while (this.eventIterator.hasNext()) {
            CesEvent previousEvent = mostRecentEvent;
            mostRecentEvent = (CesEvent)this.eventIterator.next();
            Duration elapsedGranularTime = Duration.between(this.granularFirstEvent.getPlatformEvent().getConsensusTimestamp(), mostRecentEvent.getPlatformEvent().getConsensusTimestamp());
            if (previousEvent != null && CompareTo.isGreaterThan((Comparable)elapsedGranularTime, (Object)this.reportPeriod)) {
                this.reportGranularData(previousEvent);
                this.resetGranularData(mostRecentEvent);
            }
            this.collectEventData(mostRecentEvent);
            this.previousFileCount = this.fileIterator.getFileCount();
            this.previousDamagedFileCount = this.fileIterator.getDamagedFileCount();
            if (!this.eventIterator.hasNext() && this.granularEventCount > 0L) {
                this.reportGranularData(mostRecentEvent);
            }
            this.writeConsoleSummary(firstEvent, mostRecentEvent);
        }
        long rounds = mostRecentEvent.getRoundReceived() - firstEvent.getRoundReceived();
        return new EventStreamReport(this.granularInfo, new EventStreamInfo(firstEvent.getPlatformEvent().getConsensusTimestamp(), mostRecentEvent.getPlatformEvent().getConsensusTimestamp(), rounds, this.eventCount, this.applicationTransactionCount, this.fileIterator.getFileCount(), this.fileIterator.getBytesRead(), firstEvent, mostRecentEvent, this.fileIterator.getDamagedFileCount()));
    }
}

