/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.wiring.components;

import com.swirlds.component.framework.model.WiringModel;
import com.swirlds.component.framework.schedulers.TaskScheduler;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerType;
import com.swirlds.component.framework.wires.input.BindableInputWire;
import com.swirlds.component.framework.wires.input.InputWire;
import com.swirlds.component.framework.wires.output.OutputWire;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.Function;

public class PassThroughWiring<DATA_TYPE> {
    private final BindableInputWire<DATA_TYPE, DATA_TYPE> input;
    private final OutputWire<DATA_TYPE> output;
    private final TaskScheduler<DATA_TYPE> scheduler;

    public PassThroughWiring(@NonNull WiringModel model, @NonNull String inputLabel, @NonNull String componentName, @NonNull TaskSchedulerType schedulerType) {
        this(model, inputLabel, model.schedulerBuilder(Objects.requireNonNull(componentName)).withType(Objects.requireNonNull(schedulerType)).build());
    }

    public PassThroughWiring(@NonNull WiringModel model, @NonNull String inputLabel, @NonNull TaskScheduler<DATA_TYPE> scheduler) {
        Objects.requireNonNull(model);
        Objects.requireNonNull(inputLabel);
        this.scheduler = Objects.requireNonNull(scheduler);
        this.input = scheduler.buildInputWire(inputLabel);
        this.input.bind(Function.identity());
        this.output = scheduler.getOutputWire();
    }

    @NonNull
    public TaskScheduler<DATA_TYPE> getScheduler() {
        return this.scheduler;
    }

    @NonNull
    public InputWire<DATA_TYPE> getInputWire() {
        return this.input;
    }

    @NonNull
    public OutputWire<DATA_TYPE> getOutputWire() {
        return this.output;
    }
}

