/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.common.media.type.MediaTypes;
import io.helidon.http.HttpMediaType;
import java.util.function.Predicate;

public final class HttpMediaTypes {
    public static final HttpMediaType JSON_UTF_8 = HttpMediaType.builder().mediaType(MediaTypes.APPLICATION_JSON).charset("UTF-8").build();
    public static final Predicate<HttpMediaType> JSON_PREDICATE = JSON_UTF_8.or(mt -> mt.hasSuffix("json"));
    public static final HttpMediaType PLAINTEXT_UTF_8 = HttpMediaType.builder().mediaType(MediaTypes.TEXT_PLAIN).charset("UTF-8").build();
    public static final Predicate<HttpMediaType> JSON_EVENT_STREAM_PREDICATE = HttpMediaType.create(MediaTypes.TEXT_EVENT_STREAM).and(mt -> mt.hasSuffix("event-stream")).and(mt -> !mt.parameters().containsKey("element-type") || "application/json".equals(mt.parameters().get("element-type")));

    private HttpMediaTypes() {
    }
}

