/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.processor;

import java.util.Map;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.precompile.PrecompileContractRegistry;
import org.hyperledger.besu.evm.processor.MessageCallProcessor;

public class OverriddenPrecompilesMessageCallProcessor
extends MessageCallProcessor {
    public OverriddenPrecompilesMessageCallProcessor(MessageCallProcessor originalProcessor, Map<Address, Address> precompileOverrides) {
        super(originalProcessor.evm, OverriddenPrecompilesMessageCallProcessor.createRegistryWithPrecompileOverrides(originalProcessor.precompiles, precompileOverrides));
    }

    private static PrecompileContractRegistry createRegistryWithPrecompileOverrides(PrecompileContractRegistry originalRegistry, Map<Address, Address> precompileOverrides) {
        PrecompileContractRegistry newRegistry = new PrecompileContractRegistry();
        for (Address originalAddress : originalRegistry.getPrecompileAddresses()) {
            Address effectiveAddress = precompileOverrides.getOrDefault(originalAddress, originalAddress);
            newRegistry.put(effectiveAddress, originalRegistry.get(originalAddress));
        }
        return newRegistry;
    }
}

