/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.io;

import com.swirlds.config.api.Configuration;
import com.swirlds.logging.io.BufferedOutputStream;
import com.swirlds.logging.io.RolloverFileOutputStream;
import com.swirlds.logging.utils.ConfigUtils;
import com.swirlds.logging.utils.FileUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Objects;

public class OutputStreamFactory {
    private static final String FILE_NAME_PROPERTY = ".file";
    private static final String APPEND_PROPERTY = ".append";
    private static final String SIZE_PROPERTY = ".file-rolling.maxFileSize";
    private static final String MAX_ROLLOVER = ".file-rolling.maxFiles";
    private static final String DEFAULT_FILE_NAME = "swirlds-log.log";
    private static final int DEFAULT_MAX_ROLLOVER_FILES = 1;
    private static final int BUFFER_CAPACITY = 65536;

    public static OutputStreamFactory getInstance() {
        return InstanceHolder.INSTANCE;
    }

    @NonNull
    public OutputStream outputStream(@NonNull Configuration configuration, @NonNull String handlerName) throws IOException {
        Objects.requireNonNull(configuration, "configuration must not be null");
        Objects.requireNonNull(handlerName, "handlerName must not be null");
        String propertyPrefix = "logging.handler.%s".formatted(handlerName);
        Path filePath = ConfigUtils.configValueOrElse(configuration, propertyPrefix + FILE_NAME_PROPERTY, Path.class, Path.of(DEFAULT_FILE_NAME, new String[0]));
        try {
            FileUtils.checkOrCreateParentDirectory(filePath);
            boolean append = ConfigUtils.configValueOrElse(configuration, propertyPrefix + APPEND_PROPERTY, Boolean.class, true);
            Long maxFileSize = ConfigUtils.readDataSizeInBytes(configuration, propertyPrefix + SIZE_PROPERTY);
            if (maxFileSize == null) {
                return new FileOutputStream(filePath.toFile(), append);
            }
            int maxRollingOver = ConfigUtils.configValueOrElse(configuration, propertyPrefix + MAX_ROLLOVER, Integer.class, 1);
            return new RolloverFileOutputStream(filePath, maxFileSize, append, maxRollingOver);
        }
        catch (IOException | IllegalStateException e) {
            throw new IOException("Could not create log file " + String.valueOf(filePath.toAbsolutePath()), e);
        }
    }

    @NonNull
    public OutputStream bufferedOutputStream(@NonNull Configuration configuration, @NonNull String handlerName) throws IOException {
        return new BufferedOutputStream(this.outputStream(configuration, handlerName), 65536);
    }

    private static final class InstanceHolder {
        private static final OutputStreamFactory INSTANCE = new OutputStreamFactory();

        private InstanceHolder() {
        }
    }
}

