/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.create;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.token.TokenCreateTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.scope.HederaNativeOperations;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.AddressIdConverter;
import com.hedera.node.app.service.contract.impl.exec.utils.KeyValueWrapper;
import com.hedera.node.app.service.contract.impl.exec.utils.TokenCreateWrapper;
import com.hedera.node.app.service.contract.impl.exec.utils.TokenExpiryWrapper;
import com.hedera.node.app.service.contract.impl.exec.utils.TokenKeyWrapper;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.spi.ids.EntityIdFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class CreateCommonDecoder {
    protected static final int HEDERA_TOKEN = 0;
    protected static final int INIT_SUPPLY = 1;
    protected static final int DECIMALS = 2;
    protected static final int FIXED_FEE = 3;
    protected static final int FRACTIONAL_FEE = 4;
    protected static final int NFT_FIXED_FEE = 1;
    protected static final int NFT_ROYALTY_FEE = 2;
    protected static final int METADATA = 9;

    protected List<TokenCreateWrapper.FixedFeeWrapper> decodeFixedFees(@NonNull Tuple[] fixedFeesTuples, @NonNull AddressIdConverter addressIdConverter, @NonNull EntityIdFactory entityIdFactory) {
        boolean AMOUNT = false;
        boolean TOKEN_ID = true;
        int USE_HBARS_FOR_PAYMENTS = 2;
        int USE_CURRENT_TOKEN_FOR_PAYMENT = 3;
        int FEE_COLLECTOR = 4;
        ArrayList<TokenCreateWrapper.FixedFeeWrapper> fixedFees = new ArrayList<TokenCreateWrapper.FixedFeeWrapper>(fixedFeesTuples.length);
        for (Tuple fixedFeeTuple : fixedFeesTuples) {
            long amount = (Long)fixedFeeTuple.get(0);
            TokenID tokenId = ConversionUtils.asTokenId(entityIdFactory, (Address)fixedFeeTuple.get(1));
            Boolean useHbarsForPayment = (Boolean)fixedFeeTuple.get(2);
            Boolean useCurrentTokenForPayment = (Boolean)fixedFeeTuple.get(3);
            AccountID feeCollector = addressIdConverter.convert((Address)fixedFeeTuple.get(4));
            fixedFees.add(new TokenCreateWrapper.FixedFeeWrapper(amount, (TokenID)(tokenId.tokenNum() != 0L ? tokenId : null), useHbarsForPayment, useCurrentTokenForPayment, (AccountID)(feeCollector.accountNum() != 0L ? feeCollector : null)));
        }
        return fixedFees;
    }

    protected List<TokenCreateWrapper.FractionalFeeWrapper> decodeFractionalFees(@NonNull Tuple[] fractionalFeesTuples, @NonNull AddressIdConverter addressIdConverter) {
        boolean NUMERATOR = false;
        boolean DENOMINATOR = true;
        int MINIMUM_AMOUNT = 2;
        int MAXIMUM_AMOUNT = 3;
        int NET_OF_TRANSFERS = 4;
        int FEE_COLLECTOR = 5;
        ArrayList<TokenCreateWrapper.FractionalFeeWrapper> fractionalFees = new ArrayList<TokenCreateWrapper.FractionalFeeWrapper>(fractionalFeesTuples.length);
        for (Tuple fractionalFeeTuple : fractionalFeesTuples) {
            long numerator = (Long)fractionalFeeTuple.get(0);
            long denominator = (Long)fractionalFeeTuple.get(1);
            long minimumAmount = (Long)fractionalFeeTuple.get(2);
            long maximumAmount = (Long)fractionalFeeTuple.get(3);
            Boolean netOfTransfers = (Boolean)fractionalFeeTuple.get(4);
            AccountID feeCollector = addressIdConverter.convert((Address)fractionalFeeTuple.get(5));
            fractionalFees.add(new TokenCreateWrapper.FractionalFeeWrapper(numerator, denominator, minimumAmount, maximumAmount, netOfTransfers, (AccountID)(feeCollector.accountNum() != 0L ? feeCollector : null)));
        }
        return fractionalFees;
    }

    protected List<TokenCreateWrapper.RoyaltyFeeWrapper> decodeRoyaltyFees(@NonNull Tuple[] royaltyFeesTuples, @NonNull AddressIdConverter addressIdConverter, @NonNull EntityIdFactory entityIdFactory) {
        boolean NUMERATOR = false;
        boolean DENOMINATOR = true;
        int FIXED_FEE_AMOUNT = 2;
        int FIXED_FEE_TOKEN_ID = 3;
        int FIXED_FEE_USE_HBARS = 4;
        ArrayList<TokenCreateWrapper.RoyaltyFeeWrapper> decodedRoyaltyFees = new ArrayList<TokenCreateWrapper.RoyaltyFeeWrapper>(royaltyFeesTuples.length);
        for (Tuple royaltyFeeTuple : royaltyFeesTuples) {
            AccountID feeCollector;
            long numerator = (Long)royaltyFeeTuple.get(0);
            long denominator = (Long)royaltyFeeTuple.get(1);
            long fixedFeeAmount = (Long)royaltyFeeTuple.get(2);
            TokenID fixedFeeTokenId = ConversionUtils.asTokenId(entityIdFactory, (Address)royaltyFeeTuple.get(3));
            Boolean fixedFeeUseHbars = (Boolean)royaltyFeeTuple.get(4);
            TokenCreateWrapper.FixedFeeWrapper fixedFee = null;
            if (fixedFeeAmount != 0L || fixedFeeTokenId.tokenNum() != 0L || Boolean.TRUE.equals(fixedFeeUseHbars)) {
                fixedFee = new TokenCreateWrapper.FixedFeeWrapper(fixedFeeAmount, (TokenID)(fixedFeeTokenId.tokenNum() != 0L ? fixedFeeTokenId : null), fixedFeeUseHbars, false, null);
            }
            decodedRoyaltyFees.add(new TokenCreateWrapper.RoyaltyFeeWrapper(numerator, denominator, fixedFee, (AccountID)((feeCollector = addressIdConverter.convert((Address)royaltyFeeTuple.get(5))).accountNum() != 0L ? feeCollector : null)));
        }
        return decodedRoyaltyFees;
    }

    protected TokenCreateWrapper getTokenCreateWrapper(@NonNull Tuple tokenCreateStruct, boolean isFungible, long initSupply, int decimals, @NonNull AccountID senderId, @NonNull HederaNativeOperations nativeOperations, @NonNull AddressIdConverter addressIdConverter) {
        boolean TOKEN_NAME = false;
        boolean TOKEN_SYMBOL = true;
        int TOKEN_TREASURY = 2;
        int MEMO = 3;
        int SUPPLY_TYPE = 4;
        int MAX_SUPPLY = 5;
        int FREEZE_DEFAULT = 6;
        int TOKEN_KEYS = 7;
        int TOKEN_EXPIRY = 8;
        String tokenName = (String)tokenCreateStruct.get(0);
        String tokenSymbol = (String)tokenCreateStruct.get(1);
        AccountID tokenTreasury = addressIdConverter.convert((Address)tokenCreateStruct.get(2));
        String memo = (String)tokenCreateStruct.get(3);
        Boolean isSupplyTypeFinite = (Boolean)tokenCreateStruct.get(4);
        long maxSupply = (Long)tokenCreateStruct.get(5);
        Boolean isFreezeDefault = (Boolean)tokenCreateStruct.get(6);
        List<TokenKeyWrapper> tokenKeys = this.decodeTokenKeys((Tuple[])tokenCreateStruct.get(7), addressIdConverter, nativeOperations);
        TokenExpiryWrapper tokenExpiry = this.decodeTokenExpiry((Tuple)tokenCreateStruct.get(8), addressIdConverter);
        TokenCreateWrapper tokenCreateWrapper = new TokenCreateWrapper(isFungible, tokenName, tokenSymbol, (AccountID)(tokenTreasury.accountNumOrElse(Long.valueOf(0L)) != 0L ? tokenTreasury : null), memo, isSupplyTypeFinite, initSupply, decimals, maxSupply, isFreezeDefault, tokenKeys, tokenExpiry);
        tokenCreateWrapper.setAllInheritedKeysTo(nativeOperations.getAccountKey(senderId));
        return tokenCreateWrapper;
    }

    protected List<TokenKeyWrapper> decodeTokenKeys(@NonNull Tuple[] tokenKeysTuples, @NonNull AddressIdConverter addressIdConverter, @NonNull HederaNativeOperations nativeOperations) {
        boolean KEY_TYPE = false;
        boolean KEY_VALUE_TYPE = true;
        boolean INHERIT_ACCOUNT_KEY = false;
        boolean CONTRACT_ID = true;
        int ED25519 = 2;
        int ECDSA_SECP_256K1 = 3;
        int DELEGATABLE_CONTRACT_ID = 4;
        ArrayList<TokenKeyWrapper> tokenKeys = new ArrayList<TokenKeyWrapper>(tokenKeysTuples.length);
        for (Tuple tokenKeyTuple : tokenKeysTuples) {
            int keyType = ((BigInteger)tokenKeyTuple.get(0)).intValue();
            Tuple keyValueTuple = (Tuple)tokenKeyTuple.get(1);
            Boolean inheritAccountKey = (Boolean)keyValueTuple.get(0);
            ContractID contractId = ConversionUtils.asNumericContractId(nativeOperations.entityIdFactory(), addressIdConverter.convert((Address)keyValueTuple.get(1)));
            byte[] ed25519 = (byte[])keyValueTuple.get(2);
            byte[] ecdsaSecp256K1 = (byte[])keyValueTuple.get(3);
            ContractID delegatableContractId = ConversionUtils.asNumericContractId(nativeOperations.entityIdFactory(), addressIdConverter.convert((Address)keyValueTuple.get(4)));
            tokenKeys.add(new TokenKeyWrapper(keyType, new KeyValueWrapper(inheritAccountKey, (ContractID)(contractId.contractNum() != 0L ? contractId : null), ed25519, ecdsaSecp256K1, (ContractID)(delegatableContractId.contractNum() != 0L ? delegatableContractId : null))));
        }
        return tokenKeys;
    }

    protected TokenExpiryWrapper decodeTokenExpiry(@NonNull Tuple expiryTuple, @NonNull AddressIdConverter addressIdConverter) {
        boolean SECOND = false;
        boolean AUTO_RENEW_ACCOUNT = true;
        int AUTO_RENEW_PERIOD = 2;
        long second = (Long)expiryTuple.get(0);
        AccountID autoRenewAccount = addressIdConverter.convert((Address)expiryTuple.get(1));
        Duration autoRenewPeriod = Duration.newBuilder().seconds(((Long)expiryTuple.get(2)).longValue()).build();
        return new TokenExpiryWrapper(second, autoRenewAccount.accountNum() == 0L ? null : autoRenewAccount, autoRenewPeriod);
    }

    protected TransactionBody bodyOf(@NonNull TokenCreateTransactionBody.Builder tokenCreate) {
        return TransactionBody.newBuilder().tokenCreation(tokenCreate).build();
    }
}

