/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers.transfer;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.hapi.node.transaction.AssessedCustomFee;
import com.hedera.hapi.node.transaction.FixedCustomFee;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableTokenRelationStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.service.token.impl.handlers.transfer.TransferContext;
import com.hedera.node.app.service.token.impl.handlers.transfer.customfees.AssessedFeeWithPayerDebits;
import com.hedera.node.app.service.token.impl.handlers.transfer.customfees.AssessmentResult;
import com.hedera.node.app.service.token.impl.handlers.transfer.customfees.CustomFeeAssessor;
import com.hedera.node.app.service.token.impl.handlers.transfer.customfees.CustomFixedFeeAssessor;
import com.hedera.node.app.service.token.impl.handlers.transfer.customfees.CustomFractionalFeeAssessor;
import com.hedera.node.app.service.token.impl.handlers.transfer.customfees.CustomRoyaltyFeeAssessor;
import com.hedera.node.app.service.token.impl.util.TokenHandlerHelper;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.store.StoreFactory;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.config.data.LedgerConfig;
import com.hedera.node.config.data.TokensConfig;
import com.swirlds.base.utility.Pair;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomFeeAssessmentStep {
    private final CryptoTransferTransactionBody op;
    private final CustomFeeAssessor customFeeAssessor;
    private int levelNum = 0;
    private static final int MAX_PLAUSIBLE_LEVEL_NUM = 10;
    private static final Logger log = LogManager.getLogger(CustomFeeAssessmentStep.class);

    public CustomFeeAssessmentStep(@NonNull CryptoTransferTransactionBody op) {
        this.op = op;
        CustomFixedFeeAssessor fixedFeeAssessor = new CustomFixedFeeAssessor();
        CustomFractionalFeeAssessor fractionalFeeAssessor = new CustomFractionalFeeAssessor(fixedFeeAssessor);
        CustomRoyaltyFeeAssessor royaltyFeeAssessor = new CustomRoyaltyFeeAssessor(fixedFeeAssessor);
        this.customFeeAssessor = new CustomFeeAssessor(fixedFeeAssessor, fractionalFeeAssessor, royaltyFeeAssessor);
        this.customFeeAssessor.calculateAndSetInitialNftChanges(op);
    }

    public List<AssessedCustomFee> assessNumberOfCustomFees(@NonNull FeeContext feeContext) {
        Objects.requireNonNull(feeContext);
        ReadableTokenStore tokenStore = (ReadableTokenStore)feeContext.readableStore(ReadableTokenStore.class);
        ReadableTokenRelationStore tokenRelStore = (ReadableTokenRelationStore)feeContext.readableStore(ReadableTokenRelationStore.class);
        ReadableAccountStore readableStore = (ReadableAccountStore)feeContext.readableStore(ReadableAccountStore.class);
        Configuration config = feeContext.configuration();
        CustomFeeAssessmentResult result = this.assessFees(tokenStore, tokenRelStore, config, readableStore, AccountID::hasAlias);
        return result.assessedCustomFees().stream().map(AssessedFeeWithPayerDebits::assessedCustomFee).toList();
    }

    public List<CryptoTransferTransactionBody> assessCustomFees(@NonNull TransferContext transferContext) {
        Objects.requireNonNull(transferContext);
        HandleContext handleContext = transferContext.getHandleContext();
        StoreFactory storeFactory = handleContext.storeFactory();
        ReadableTokenStore tokenStore = (ReadableTokenStore)storeFactory.readableStore(ReadableTokenStore.class);
        ReadableTokenRelationStore tokenRelStore = (ReadableTokenRelationStore)storeFactory.readableStore(ReadableTokenRelationStore.class);
        ReadableAccountStore accountStore = (ReadableAccountStore)storeFactory.readableStore(ReadableAccountStore.class);
        Configuration config = handleContext.configuration();
        Predicate<AccountID> autoCreationTest = transferContext.isEnforceMonoServiceRestrictionsOnAutoCreationCustomFeePayments() ? transferContext.resolutions().values()::contains : accountId -> false;
        CustomFeeAssessmentResult result = this.assessFees(tokenStore, tokenRelStore, config, accountStore, autoCreationTest);
        Optional txnFeeMetadata = transferContext.getHandleContext().dispatchMetadata().getMetadata(HandleContext.DispatchMetadata.Type.TRANSACTION_FIXED_FEE, FixedCustomFee.class);
        if (txnFeeMetadata.isPresent()) {
            FixedCustomFee transactionFixedFee = (FixedCustomFee)txnFeeMetadata.get();
            AccountID payer = transferContext.getHandleContext().payer();
            AssessmentResult assessmentResult = new AssessmentResult(Collections.emptyList(), Collections.emptyList());
            this.customFeeAssessor.setTransactionFeesAsAssessed(payer, transactionFixedFee, assessmentResult);
            result.assessedCustomFees.addAll(assessmentResult.getAssessedFeesWithPayerDebits());
        }
        result.assessedCustomFees().forEach(transferContext::addToAssessedCustomFee);
        this.customFeeAssessor.resetInitialNftChanges();
        return result.assessedTxns();
    }

    public CustomFeeAssessmentResult assessFees(@NonNull ReadableTokenStore tokenStore, @NonNull ReadableTokenRelationStore tokenRelStore, @NonNull Configuration config, @NonNull ReadableAccountStore accountStore, @NonNull Predicate<AccountID> autoCreationTest) {
        TokensConfig tokensConfig = (TokensConfig)config.getConfigData(TokensConfig.class);
        int maxCustomFeeDepth = tokensConfig.maxCustomFeeDepth();
        ArrayList<AssessedFeeWithPayerDebits> customFeesAssessed = new ArrayList<AssessedFeeWithPayerDebits>();
        CryptoTransferTransactionBody txnToAssess = this.op;
        ArrayList<CryptoTransferTransactionBody> assessedTxns = new ArrayList<CryptoTransferTransactionBody>();
        List tokenTransfers = this.op.tokenTransfers();
        List hbarTransfers = this.op.transfersOrElse(TransferList.DEFAULT).accountAmounts();
        do {
            HandleException.validateTrue((this.levelNum <= maxCustomFeeDepth ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.CUSTOM_FEE_CHARGING_EXCEEDED_MAX_RECURSION_DEPTH);
            AssessmentResult result = this.assessCustomFeesFrom(hbarTransfers, tokenTransfers, tokenStore, tokenRelStore, accountStore, autoCreationTest);
            if (result.getAssessedFeesWithPayerDebits().isEmpty()) break;
            CryptoTransferTransactionBody modifiedInputBody = this.changedInputTxn(txnToAssess, result);
            assessedTxns.add(modifiedInputBody);
            customFeesAssessed.addAll(result.getAssessedFeesWithPayerDebits());
            txnToAssess = this.buildBodyFromAdjustments(result);
            tokenTransfers = txnToAssess.tokenTransfers();
            hbarTransfers = txnToAssess.transfersOrElse(TransferList.DEFAULT).accountAmounts();
            ++this.levelNum;
        } while (!tokenTransfers.isEmpty() && this.levelNum <= 10);
        if (this.levelNum > 10) {
            log.error("Recursive charging exceeded maximum plausible depth for transaction {}", (Object)this.op);
            throw new IllegalStateException("Custom fee charging exceeded max recursion depth");
        }
        if (!hbarTransfers.isEmpty() || !tokenTransfers.isEmpty()) {
            assessedTxns.add(txnToAssess);
        }
        if (!customFeesAssessed.isEmpty()) {
            int maxBalanceChanges = ((LedgerConfig)config.getConfigData(LedgerConfig.class)).xferBalanceChangesMaxLen();
            HandleException.validateTrue((this.numUniqueAdjustmentsIn(assessedTxns) <= maxBalanceChanges ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.CUSTOM_FEE_CHARGING_EXCEEDED_MAX_ACCOUNT_AMOUNTS);
        }
        return new CustomFeeAssessmentResult(assessedTxns, customFeesAssessed);
    }

    private int numUniqueAdjustmentsIn(List<CryptoTransferTransactionBody> assessedTxns) {
        int numOwnershipChanges = 0;
        HashSet<AccountID> uniqueHbarAdjustments = new HashSet<AccountID>();
        HashSet<Pair> uniqueTokenAdjustments = new HashSet<Pair>();
        for (CryptoTransferTransactionBody txn : assessedTxns) {
            for (AccountAmount aa : txn.transfersOrElse(TransferList.DEFAULT).accountAmounts()) {
                uniqueHbarAdjustments.add(aa.accountID());
            }
            for (TokenTransferList xfer : txn.tokenTransfers()) {
                for (AccountAmount aa : xfer.transfers()) {
                    uniqueTokenAdjustments.add(Pair.of((Object)aa.accountID(), (Object)xfer.token()));
                }
                numOwnershipChanges += xfer.nftTransfers().size();
            }
        }
        return numOwnershipChanges + uniqueHbarAdjustments.size() + uniqueTokenAdjustments.size();
    }

    private CryptoTransferTransactionBody changedInputTxn(CryptoTransferTransactionBody op, AssessmentResult result) {
        CryptoTransferTransactionBody.Builder copy = op.copyBuilder();
        Map<AccountID, Long> changedHbarTransfers = result.getMutableInputBalanceAdjustments().get(AssessmentResult.HBAR_TOKEN_ID);
        TransferList.Builder transferList = TransferList.newBuilder();
        List<AccountAmount> hbarList = CustomFeeAssessmentStep.getRevisedAdjustments(op.transfersOrElse(TransferList.DEFAULT).accountAmounts(), changedHbarTransfers);
        copy.transfers(transferList.accountAmounts(hbarList).build());
        Map<TokenID, Map<AccountID, Long>> changedFungibleTokenTransfers = result.getMutableInputBalanceAdjustments();
        ArrayList<TokenTransferList> tokenTransferLists = new ArrayList<TokenTransferList>();
        for (TokenTransferList xfers : op.tokenTransfers()) {
            boolean includedNetNewChanges;
            TokenID token = xfers.token();
            if (!changedFungibleTokenTransfers.containsKey(token)) {
                tokenTransferLists.add(xfers);
                continue;
            }
            Map<AccountID, Long> postAssessmentBalances = changedFungibleTokenTransfers.get(token);
            List adjustsHere = xfers.transfers();
            boolean bl = includedNetNewChanges = postAssessmentBalances.size() > adjustsHere.size();
            if (includedNetNewChanges || this.balancesChangedBetween(adjustsHere, postAssessmentBalances)) {
                List<AccountAmount> newTransfers = CustomFeeAssessmentStep.getRevisedAdjustments(adjustsHere, postAssessmentBalances);
                tokenTransferLists.add(xfers.copyBuilder().transfers(newTransfers).build());
                continue;
            }
            tokenTransferLists.add(xfers);
        }
        copy.tokenTransfers(tokenTransferLists);
        return copy.build();
    }

    @NonNull
    private static List<AccountAmount> getRevisedAdjustments(List<AccountAmount> adjustsHere, Map<AccountID, Long> newBalances) {
        ArrayList<AccountAmount> newTransfers = new ArrayList<AccountAmount>(adjustsHere.size());
        for (AccountAmount accountAmount : adjustsHere) {
            Long newAmount = newBalances.getOrDefault(accountAmount.accountID(), accountAmount.amount());
            newTransfers.add(accountAmount.copyBuilder().amount(newAmount.longValue()).build());
            newBalances.remove(accountAmount.accountID());
        }
        for (Map.Entry entry : newBalances.entrySet()) {
            newTransfers.add(AccountAmount.newBuilder().accountID((AccountID)entry.getKey()).amount(((Long)entry.getValue()).longValue()).build());
        }
        return newTransfers;
    }

    private boolean balancesChangedBetween(@NonNull List<AccountAmount> original, @NonNull Map<AccountID, Long> postAssessmentBalances) {
        for (AccountAmount aa : original) {
            if (aa.amount() == postAssessmentBalances.getOrDefault(aa.accountID(), aa.amount()).longValue()) continue;
            return true;
        }
        return false;
    }

    private CryptoTransferTransactionBody buildBodyFromAdjustments(AssessmentResult result) {
        Map<AccountID, Long> hbarAdjustments = result.getHbarAdjustments();
        Map<TokenID, Map<AccountID, Long>> tokenAdjustments = result.getHtsAdjustments();
        CryptoTransferTransactionBody.Builder newBuilder = CryptoTransferTransactionBody.newBuilder();
        TransferList.Builder transferList = TransferList.newBuilder();
        ArrayList<AccountAmount> hbarList = new ArrayList<AccountAmount>();
        ArrayList<TokenTransferList> tokenTransferLists = new ArrayList<TokenTransferList>();
        for (Map.Entry<AccountID, Long> entry : hbarAdjustments.entrySet()) {
            hbarList.add(AccountAmount.newBuilder().accountID(entry.getKey()).amount(entry.getValue().longValue()).build());
        }
        transferList.accountAmounts(hbarList);
        newBuilder.transfers(transferList.build());
        for (Map.Entry<Object, Object> entry : tokenAdjustments.entrySet()) {
            TokenTransferList.Builder tokenTransferList = TokenTransferList.newBuilder().token((TokenID)entry.getKey());
            ArrayList<AccountAmount> aaList = new ArrayList<AccountAmount>();
            for (Map.Entry valueEntry : ((Map)entry.getValue()).entrySet()) {
                aaList.add(AccountAmount.newBuilder().accountID((AccountID)valueEntry.getKey()).amount(((Long)valueEntry.getValue()).longValue()).build());
            }
            tokenTransferList.transfers(aaList);
            tokenTransferLists.add(tokenTransferList.build());
        }
        newBuilder.tokenTransfers(tokenTransferLists);
        return newBuilder.build();
    }

    private AssessmentResult assessCustomFeesFrom(@NonNull List<AccountAmount> hbarTransfers, @NonNull List<TokenTransferList> tokenTransfers, @NonNull ReadableTokenStore tokenStore, @NonNull ReadableTokenRelationStore tokenRelStore, @NonNull ReadableAccountStore accountStore, @NonNull Predicate<AccountID> autoCreationTest) {
        AssessmentResult result = new AssessmentResult(tokenTransfers, hbarTransfers);
        for (TokenTransferList xfer : tokenTransfers) {
            TokenID tokenId = xfer.tokenOrElse(TokenID.DEFAULT);
            List ftTransfers = xfer.transfers();
            List nftTransfers = xfer.nftTransfers();
            Token token = TokenHandlerHelper.getIfUsable(tokenId, tokenStore, TokenHandlerHelper.TokenValidations.PERMIT_PAUSED);
            if (token.customFees().isEmpty()) continue;
            boolean isFungible = token.tokenType().equals((Object)TokenType.FUNGIBLE_COMMON);
            for (AccountAmount aa : ftTransfers) {
                long adjustment = aa.amount();
                HandleException.validateFalse((!isFungible && adjustment != 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.ACCOUNT_AMOUNT_TRANSFERS_ONLY_ALLOWED_FOR_FUNGIBLE_COMMON);
                if (adjustment >= 0L) continue;
                AccountID sender = aa.accountID();
                if (token.treasuryAccountIdOrThrow().equals((Object)sender)) continue;
                this.customFeeAssessor.assess(sender, token, null, result, tokenRelStore, accountStore, autoCreationTest);
            }
            if (isFungible) {
                HandleException.validateTrue((boolean)nftTransfers.isEmpty(), (ResponseCodeEnum)ResponseCodeEnum.NFT_TRANSFERS_ONLY_ALLOWED_FOR_NON_FUNGIBLE_UNIQUE);
            }
            for (NftTransfer nftTransfer : nftTransfers) {
                if (token.treasuryAccountIdOrThrow().equals((Object)nftTransfer.senderAccountID())) continue;
                this.customFeeAssessor.assess(nftTransfer.senderAccountID(), token, nftTransfer.receiverAccountID(), result, tokenRelStore, accountStore, autoCreationTest);
            }
        }
        return result;
    }

    public record CustomFeeAssessmentResult(@NonNull List<CryptoTransferTransactionBody> assessedTxns, @NonNull List<AssessedFeeWithPayerDebits> assessedCustomFees) {
    }
}

