/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractExtCallOperation;

public class ExtCallOperation
extends AbstractExtCallOperation {
    public static final int OPCODE = 248;
    static final int STACK_VALUE = 3;

    public ExtCallOperation(GasCalculator gasCalculator) {
        super(248, "EXTCALL", 4, 1, gasCalculator);
    }

    @Override
    protected Wei value(MessageFrame frame) {
        return Wei.wrap((Bytes)frame.getStackItem(3));
    }

    @Override
    protected Wei apparentValue(MessageFrame frame) {
        return this.value(frame);
    }

    @Override
    protected long inputDataOffset(MessageFrame frame) {
        return Words.clampedToLong(frame.getStackItem(1));
    }

    @Override
    protected long inputDataLength(MessageFrame frame) {
        return Words.clampedToLong(frame.getStackItem(2));
    }

    @Override
    protected Address address(MessageFrame frame) {
        return this.to(frame);
    }

    @Override
    protected Address sender(MessageFrame frame) {
        return frame.getRecipientAddress();
    }
}

