/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.precompile;

import javax.annotation.Nonnull;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.hyperledger.besu.crypto.Hash;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.precompile.AbstractPrecompiledContract;
import org.hyperledger.besu.evm.precompile.PrecompiledContract;

public class RIPEMD160PrecompiledContract
extends AbstractPrecompiledContract {
    public RIPEMD160PrecompiledContract(GasCalculator gasCalculator) {
        super("RIPEMD160", gasCalculator);
    }

    @Override
    public long gasRequirement(Bytes input) {
        return this.gasCalculator().ripemd160PrecompiledContractGasCost(input);
    }

    @Override
    @Nonnull
    public PrecompiledContract.PrecompileContractResult computePrecompile(Bytes input, @Nonnull MessageFrame messageFrame) {
        return PrecompiledContract.PrecompileContractResult.success((Bytes)Bytes32.leftPad((Bytes)Hash.ripemd160((Bytes)input)));
    }
}

