/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.fees.pricing;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hedera.node.app.hapi.fees.pricing.FeeSchedules;
import com.hedera.node.app.hapi.fees.pricing.ResourceProvider;
import com.hedera.node.app.hapi.fees.pricing.UsableResource;
import com.hederahashgraph.api.proto.java.HederaFunctionality;
import com.hederahashgraph.api.proto.java.SubType;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class ScheduleGenerator {
    private static final String FEE_SCHEDULE_FEES_KEY = "fees";
    private static final String FEE_SCHEDULE_TYPE_KEY = "subType";
    private static final String FEE_SCHEDULE_ENTRY_KEY = "transactionFeeSchedule";
    private static final String FEE_SCHEDULE_FUNCTION_KEY = "hederaFunctionality";
    private static final Instant CURRENT_SCHEDULE_EXPIRY = LocalDateTime.of(2021, Month.SEPTEMBER, 2, 0, 0).plusMonths(1L).toInstant(ZoneOffset.UTC);
    private static final Instant NEXT_SCHEDULE_EXPIRY = LocalDateTime.of(2021, Month.SEPTEMBER, 2, 0, 0).plusMonths(2L).toInstant(ZoneOffset.UTC);
    private static final FeeSchedules feeSchedules = new FeeSchedules();
    static final List<Pair<HederaFunctionality, List<SubType>>> SUPPORTED_FUNCTIONS = List.of(Pair.of((Object)HederaFunctionality.ContractAutoRenew, List.of(SubType.DEFAULT)), Pair.of((Object)HederaFunctionality.CryptoTransfer, List.of(SubType.DEFAULT, SubType.TOKEN_FUNGIBLE_COMMON, SubType.TOKEN_FUNGIBLE_COMMON_WITH_CUSTOM_FEES, SubType.TOKEN_NON_FUNGIBLE_UNIQUE, SubType.TOKEN_NON_FUNGIBLE_UNIQUE_WITH_CUSTOM_FEES)), Pair.of((Object)HederaFunctionality.CryptoCreate, List.of(SubType.DEFAULT)), Pair.of((Object)HederaFunctionality.CryptoUpdate, List.of(SubType.DEFAULT)), Pair.of((Object)HederaFunctionality.CryptoApproveAllowance, List.of(SubType.DEFAULT)), Pair.of((Object)HederaFunctionality.CryptoDeleteAllowance, List.of(SubType.DEFAULT)), Pair.of((Object)HederaFunctionality.FileAppend, List.of(SubType.DEFAULT)), Pair.of((Object)HederaFunctionality.TokenCreate, List.of(SubType.TOKEN_FUNGIBLE_COMMON, SubType.TOKEN_FUNGIBLE_COMMON_WITH_CUSTOM_FEES, SubType.TOKEN_NON_FUNGIBLE_UNIQUE, SubType.TOKEN_NON_FUNGIBLE_UNIQUE_WITH_CUSTOM_FEES)), Pair.of((Object)HederaFunctionality.TokenMint, List.of(SubType.TOKEN_FUNGIBLE_COMMON, SubType.TOKEN_NON_FUNGIBLE_UNIQUE)), Pair.of((Object)HederaFunctionality.TokenBurn, List.of(SubType.TOKEN_FUNGIBLE_COMMON, SubType.TOKEN_NON_FUNGIBLE_UNIQUE)), Pair.of((Object)HederaFunctionality.TokenAccountWipe, List.of(SubType.TOKEN_FUNGIBLE_COMMON, SubType.TOKEN_NON_FUNGIBLE_UNIQUE)), Pair.of((Object)HederaFunctionality.TokenFeeScheduleUpdate, List.of(SubType.DEFAULT)), Pair.of((Object)HederaFunctionality.TokenFreezeAccount, List.of(SubType.DEFAULT)), Pair.of((Object)HederaFunctionality.TokenUnfreezeAccount, List.of(SubType.DEFAULT)), Pair.of((Object)HederaFunctionality.TokenPause, List.of(SubType.DEFAULT)), Pair.of((Object)HederaFunctionality.TokenUnpause, List.of(SubType.DEFAULT)), Pair.of((Object)HederaFunctionality.ConsensusSubmitMessage, List.of(SubType.DEFAULT)), Pair.of((Object)HederaFunctionality.ScheduleCreate, List.of(SubType.DEFAULT, SubType.SCHEDULE_CREATE_CONTRACT_CALL)), Pair.of((Object)HederaFunctionality.UtilPrng, List.of(SubType.DEFAULT)));

    String feeSchedulesFor(List<Pair<HederaFunctionality, List<SubType>>> data) throws IOException {
        ArrayList<Map<String, Object>> currentFeeSchedules = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> nextFeeSchedules = new ArrayList<Map<String, Object>>();
        for (Pair<HederaFunctionality, List<SubType>> datum : data) {
            HederaFunctionality function = (HederaFunctionality)datum.getKey();
            List subTypes = (List)datum.getValue();
            Map<String, Object> tfs = this.pricesAsTfs(function, subTypes);
            currentFeeSchedules.add(tfs);
            nextFeeSchedules.add(tfs);
        }
        currentFeeSchedules.add(Map.of("expiryTime", CURRENT_SCHEDULE_EXPIRY.getEpochSecond()));
        nextFeeSchedules.add(Map.of("expiryTime", NEXT_SCHEDULE_EXPIRY.getEpochSecond()));
        List everything = List.of(Map.of("currentFeeSchedule", currentFeeSchedules), Map.of("nextFeeSchedule", nextFeeSchedules));
        return new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(everything);
    }

    private Map<String, Object> pricesAsTfs(HederaFunctionality function, List<SubType> subTypes) throws IOException {
        HashMap<String, Object> transactionFeeSchedule = new HashMap<String, Object>();
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        details.put(FEE_SCHEDULE_FUNCTION_KEY, function.toString());
        ArrayList allTypedPrices = new ArrayList();
        for (SubType subType : subTypes) {
            LinkedHashMap<String, Object> typedPrices = new LinkedHashMap<String, Object>();
            typedPrices.put(FEE_SCHEDULE_TYPE_KEY, subType.toString());
            Map<ResourceProvider, Map<UsableResource, Long>> prices = feeSchedules.canonicalPricesFor(function, subType);
            for (ResourceProvider provider : (ResourceProvider[])ResourceProvider.class.getEnumConstants()) {
                LinkedHashMap<String, Long> constrainedPrices = new LinkedHashMap<String, Long>();
                Map<UsableResource, Long> providerPrices = prices.get((Object)provider);
                for (UsableResource resource : (UsableResource[])UsableResource.class.getEnumConstants()) {
                    Long price = providerPrices.get((Object)resource);
                    constrainedPrices.put(resource.toString().toLowerCase(), price);
                }
                constrainedPrices.put("min", 0L);
                constrainedPrices.put("max", 1000000000000000L);
                typedPrices.put(provider.jsonKey(), constrainedPrices);
            }
            allTypedPrices.add(typedPrices);
        }
        details.put(FEE_SCHEDULE_FEES_KEY, allTypedPrices);
        transactionFeeSchedule.put(FEE_SCHEDULE_ENTRY_KEY, details);
        return transactionFeeSchedule;
    }
}

