/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.datatypes;

import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.ethereum.rlp.RLPInput;
import org.hyperledger.besu.ethereum.rlp.RLPOutput;

public class Blob {
    final Bytes data;

    public Blob(Bytes data) {
        this.data = data;
    }

    public static Blob readFrom(RLPInput input) {
        Bytes bytes = input.readBytes();
        return new Blob(bytes);
    }

    public void writeTo(RLPOutput out) {
        out.writeBytes(this.data);
    }

    public Bytes getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Blob blob = (Blob)o;
        return Objects.equals(this.getData(), blob.getData());
    }

    public int hashCode() {
        return Objects.hash(this.getData());
    }
}

