/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.state.hooks;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.HookId;
import com.hedera.hapi.node.state.hooks.EvmHookState;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.HtsSystemContract;
import com.hedera.node.app.service.contract.impl.state.AbstractProxyEvmAccount;
import com.hedera.node.app.service.contract.impl.state.EvmFrameState;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.code.CodeFactory;

public class ProxyEvmHook
extends AbstractProxyEvmAccount {
    private final EvmHookState hookState;
    private final CodeFactory codeFactory;

    public ProxyEvmHook(@NonNull EvmFrameState state, @NonNull EvmHookState hookState, CodeFactory codeFactory) {
        super(ProxyEvmHook.getOwnerId(hookState.hookId()), state);
        this.hookState = Objects.requireNonNull(hookState);
        this.codeFactory = codeFactory;
    }

    @Override
    @NonNull
    public Code getEvmCode(@NonNull Bytes functionSelector, @NonNull CodeFactory codeFactory) {
        return codeFactory.createCode(this.getCode(), false);
    }

    @Override
    public Address getAddress() {
        return HtsSystemContract.HTS_HOOKS_16D_CONTRACT_ADDRESS;
    }

    @NonNull
    public Bytes getCode() {
        return this.state.getCode(this.hookState.hookContractIdOrThrow());
    }

    @NonNull
    public Hash getCodeHash() {
        return this.state.getCodeHash(this.hookState.hookContractIdOrThrow(), this.codeFactory);
    }

    @NonNull
    private static AccountID getOwnerId(@NonNull HookId hookId) {
        return Objects.requireNonNull(hookId).entityIdOrThrow().hasAccountId() ? hookId.entityIdOrThrow().accountIdOrThrow() : ProxyEvmHook.asAccountId(hookId.entityIdOrThrow().contractIdOrThrow());
    }

    private static AccountID asAccountId(ContractID contractID) {
        return AccountID.newBuilder().shardNum(contractID.shardNum()).realmNum(contractID.realmNum()).accountNum(contractID.contractNumOrThrow().longValue()).build();
    }
}

