/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.common.GenericType;
import io.helidon.common.types.ResolvedType;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.service.registry.ActivationPhase;
import io.helidon.service.registry.ActivationResult;
import io.helidon.service.registry.Activators;
import io.helidon.service.registry.Bindings;
import io.helidon.service.registry.CoreServiceRegistry;
import io.helidon.service.registry.DependencyBlueprint;
import io.helidon.service.registry.DependencyContext;
import io.helidon.service.registry.FactoryType;
import io.helidon.service.registry.GeneratedService;
import io.helidon.service.registry.InterceptionMetadata;
import io.helidon.service.registry.Lookup;
import io.helidon.service.registry.Qualifier;
import io.helidon.service.registry.Service;
import io.helidon.service.registry.ServiceDescriptor;
import io.helidon.service.registry.ServiceInfo;
import io.helidon.service.registry.ServiceInstance;
import io.helidon.service.registry.ServiceProvider;
import io.helidon.service.registry.ServiceRegistryException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

final class ActivatorsPerLookup {
    private ActivatorsPerLookup() {
    }

    static class OnDemandInstance<T> {
        private final ReentrantLock lock = new ReentrantLock();
        private final DependencyContext ctx;
        private final InterceptionMetadata interceptionMetadata;
        private final ServiceDescriptor<T> source;

        OnDemandInstance(DependencyContext ctx, InterceptionMetadata interceptionMetadata, ServiceDescriptor<T> source) {
            this.ctx = ctx;
            this.interceptionMetadata = interceptionMetadata;
            this.source = source;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        T get(ActivationPhase phase) {
            if (this.lock.isHeldByCurrentThread()) {
                throw new ServiceRegistryException("Cyclic dependency, attempting to obtain an instance of " + this.source.serviceType().fqName() + " while instantiating it");
            }
            try {
                this.lock.lock();
                if (phase.ordinal() >= ActivationPhase.CONSTRUCTING.ordinal()) {
                    Object instance = this.source.instantiate(this.ctx, this.interceptionMetadata);
                    if (phase.ordinal() >= ActivationPhase.INJECTING.ordinal()) {
                        LinkedHashSet<String> injected = new LinkedHashSet<String>();
                        this.source.inject(this.ctx, this.interceptionMetadata, injected, instance);
                    }
                    if (phase.ordinal() >= ActivationPhase.POST_CONSTRUCTING.ordinal()) {
                        this.source.postConstruct(instance);
                    }
                    Object object = instance;
                    return (T)object;
                }
            }
            finally {
                this.lock.unlock();
            }
            throw new ServiceRegistryException("An instance was requested even though lifecycle is limited to phase: " + String.valueOf((Object)phase));
        }
    }

    private record QualifiedOnDemandInstance<T>(OnDemandInstance<T> serviceInstance, Set<Qualifier> qualifiers) {
        static <T> QualifiedOnDemandInstance<T> create(ServiceProvider<T> provider, Bindings.ServiceBindingPlan bindingPlan, DependencyContext dependencyContext, ServiceInstance<?> driver) {
            Set<Qualifier> qualifiers = driver.qualifiers();
            Qualifier name = qualifiers.stream().filter(Predicate.not((Predicate<Qualifier>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lio/helidon/service/registry/Qualifier;)Z)((Qualifier)Qualifier.WILDCARD_NAMED))).filter(it -> Service.Named.TYPE.equals((Object)it.typeName())).findFirst().orElse(Qualifier.DEFAULT_NAMED);
            Set<Qualifier> newQualifiers = provider.descriptor().qualifiers().stream().filter(Predicate.not((Predicate<Qualifier>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lio/helidon/service/registry/Qualifier;)Z)((Qualifier)Qualifier.WILDCARD_NAMED))).collect(Collectors.toSet());
            newQualifiers.add(name);
            DependencyContext targetDependencyContext = Activators.PerInstanceActivator.updatePlan(bindingPlan, dependencyContext, driver, name);
            return new QualifiedOnDemandInstance<T>(new OnDemandInstance<T>(targetDependencyContext, provider.interceptionMetadata(), provider.descriptor()), newQualifiers);
        }
    }

    static class PerInstanceActivator<T>
    extends Activators.BaseActivator<T> {
        private final CoreServiceRegistry registry;
        private final Bindings.ServiceBindingPlan bindingPlan;
        private final ResolvedType createFor;
        private List<QualifiedOnDemandInstance<T>> serviceInstances;

        PerInstanceActivator(CoreServiceRegistry registry, DependencyContext dependencyContext, Bindings.ServiceBindingPlan bindingPlan, ServiceProvider<T> provider, GeneratedService.PerInstanceDescriptor dbd) {
            super(provider, dependencyContext);
            this.registry = registry;
            this.bindingPlan = bindingPlan;
            this.createFor = ResolvedType.create((TypeName)dbd.createFor());
        }

        @Override
        protected void construct(ActivationResult.Builder response) {
            List<ServiceInfo> services = this.registry.servicesByContract(this.createFor);
            this.serviceInstances = services.stream().map(this.registry::serviceManager).flatMap(it -> it.activator().instances(Lookup.EMPTY).stream().flatMap(Collection::stream).map(qi -> it.registryInstance(Lookup.EMPTY, qi))).map(it -> QualifiedOnDemandInstance.create(this.provider, this.bindingPlan, this.dependencyContext, it)).collect(Collectors.toList());
        }

        @Override
        protected Optional<List<Service.QualifiedInstance<T>>> targetInstances() {
            return Optional.of(this.serviceInstances.stream().map(it -> Service.QualifiedInstance.create(it.serviceInstance().get(this.currentPhase), it.qualifiers())).toList());
        }

        @Override
        protected void preDestroy(ActivationResult.Builder response) {
            this.serviceInstances = null;
        }
    }

    static class ServicesFactoryActivator<T>
    extends SingleServiceActivator<T> {
        ServicesFactoryActivator(ServiceProvider<T> provider, DependencyContext dependencyContext) {
            super(provider, dependencyContext);
        }

        @Override
        protected Optional<List<Service.QualifiedInstance<T>>> targetInstances(Lookup lookup) {
            Service.ServicesFactory instanceSupplier = (Service.ServicesFactory)this.serviceInstance.get(this.currentPhase);
            if (this.requestedProvider(lookup, FactoryType.SERVICES)) {
                return Optional.of(List.of(Service.QualifiedInstance.create(instanceSupplier, this.descriptor().qualifiers())));
            }
            ArrayList response = new ArrayList();
            for (Service.QualifiedInstance instance : instanceSupplier.services()) {
                if (!lookup.matchesQualifiers(instance.qualifiers())) continue;
                response.add(instance);
            }
            return Optional.of(List.copyOf(response));
        }
    }

    static class IpFactoryActivator<T>
    extends SingleServiceActivator<T> {
        IpFactoryActivator(ServiceProvider<T> provider, DependencyContext dependencyContext) {
            super(provider, dependencyContext);
        }

        @Override
        protected Optional<List<Service.QualifiedInstance<T>>> targetInstances(Lookup lookup) {
            if (this.serviceInstance == null) {
                return Optional.empty();
            }
            Service.InjectionPointFactory ipProvider = (Service.InjectionPointFactory)this.serviceInstance.get(this.currentPhase);
            if (this.requestedProvider(lookup, FactoryType.INJECTION_POINT)) {
                Service.InjectionPointFactory instance = ipProvider;
                return Optional.of(List.of(Service.QualifiedInstance.create(instance, this.provider.descriptor().qualifiers())));
            }
            try {
                return Optional.of(ipProvider.list(lookup));
            }
            catch (RuntimeException e) {
                throw new ServiceRegistryException("Failed to list instances in InjectionPointProvider: " + ipProvider.getClass().getName(), e);
            }
        }
    }

    static class QualifiedFactoryActivator<T>
    extends SingleServiceActivator<T> {
        private final TypeName supportedQualifier;
        private final Set<ResolvedType> supportedContracts;
        private final boolean anyMatch;

        QualifiedFactoryActivator(ServiceProvider<T> provider, DependencyContext dependencyContext, GeneratedService.QualifiedFactoryDescriptor qpd) {
            super(provider, dependencyContext);
            this.supportedQualifier = qpd.qualifierType();
            this.supportedContracts = provider.descriptor().contracts().stream().filter(it -> !Service.QualifiedFactory.TYPE.equals((Object)it.type())).collect(Collectors.toSet());
            this.anyMatch = this.supportedContracts.contains(ResolvedType.create((TypeName)TypeNames.OBJECT));
        }

        @Override
        protected Optional<List<Service.QualifiedInstance<T>>> targetInstances(Lookup lookup) {
            if (this.serviceInstance == null) {
                return Optional.empty();
            }
            return lookup.qualifiers().stream().filter(it -> this.supportedQualifier.equals((Object)it.typeName())).findFirst().flatMap(qualifier -> this.targetInstances(lookup, (Qualifier)qualifier));
        }

        private Optional<List<Service.QualifiedInstance<T>>> targetInstances(Lookup lookup, Qualifier qualifier) {
            if (lookup.contracts().size() == 1 && (this.anyMatch || this.supportedContracts.containsAll(lookup.contracts()))) {
                Optional<GenericType> genericType = lookup.dependency().map(DependencyBlueprint::contractType);
                GenericType contract = genericType.or(lookup::contractType).orElse(GenericType.OBJECT);
                return Optional.of(this.targetInstances(lookup, qualifier, contract));
            }
            return Optional.empty();
        }

        private List<Service.QualifiedInstance<T>> targetInstances(Lookup lookup, Qualifier qualifier, GenericType<T> contract) {
            Service.QualifiedFactory qProvider = (Service.QualifiedFactory)this.serviceInstance.get(this.currentPhase);
            return qProvider.list(qualifier, lookup, contract);
        }
    }

    static class SupplierActivator<T>
    extends SingleServiceActivator<T> {
        SupplierActivator(ServiceProvider<T> provider, DependencyContext dependencyContext) {
            super(provider, dependencyContext);
        }

        @Override
        protected Optional<List<Service.QualifiedInstance<T>>> targetInstances(Lookup lookup) {
            if (this.requestedProvider(lookup, FactoryType.SUPPLIER)) {
                if (this.serviceInstance == null) {
                    return Optional.empty();
                }
                Object instance = this.serviceInstance.get(this.currentPhase);
                return Optional.of(List.of(Service.QualifiedInstance.create(instance, this.provider.descriptor().qualifiers())));
            }
            return this.targetInstances();
        }

        @Override
        protected Optional<List<Service.QualifiedInstance<T>>> targetInstances() {
            if (this.serviceInstance == null) {
                return Optional.empty();
            }
            Supplier instanceSupplier = (Supplier)this.serviceInstance.get(this.currentPhase);
            Object x = instanceSupplier.get();
            if (x instanceof Optional) {
                Optional opt = (Optional)x;
                return opt.map(value -> List.of(Service.QualifiedInstance.create(value, this.provider.descriptor().qualifiers())));
            }
            return Optional.of(List.of(Service.QualifiedInstance.create(x, this.provider.descriptor().qualifiers())));
        }
    }

    static class SingleServiceActivator<T>
    extends Activators.BaseActivator<T> {
        protected OnDemandInstance<T> serviceInstance;

        SingleServiceActivator(ServiceProvider<T> provider, DependencyContext dependencyContext) {
            super(provider, dependencyContext);
        }

        @Override
        protected Optional<List<Service.QualifiedInstance<T>>> targetInstances() {
            if (this.serviceInstance == null) {
                return Optional.empty();
            }
            return Optional.of(List.of(Service.QualifiedInstance.create(this.serviceInstance.get(this.currentPhase), this.provider.descriptor().qualifiers())));
        }

        @Override
        protected void construct(ActivationResult.Builder response) {
            this.serviceInstance = new OnDemandInstance(this.dependencyContext, this.provider.interceptionMetadata(), this.provider.descriptor());
        }

        @Override
        protected void preDestroy(ActivationResult.Builder response) {
            this.serviceInstance = null;
        }
    }
}

