/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.concurrency.limits;

import io.helidon.common.concurrency.limits.IgnoreTaskException;
import io.helidon.common.concurrency.limits.LimitException;
import java.util.Optional;
import java.util.concurrent.Callable;

public interface LimitAlgorithm {
    default public <T> T invoke(Callable<T> callable) throws LimitException, Exception {
        Optional<Token> token = this.tryAcquire();
        if (token.isEmpty()) {
            throw new LimitException("No token available.");
        }
        Token permit = token.get();
        try {
            T response = callable.call();
            permit.success();
            return response;
        }
        catch (IgnoreTaskException e) {
            permit.ignore();
            return e.handle();
        }
        catch (Exception e) {
            permit.dropped();
            throw e;
        }
    }

    default public void invoke(Runnable runnable) throws LimitException, Exception {
        Optional<Token> token = this.tryAcquire();
        if (token.isEmpty()) {
            throw new LimitException("No token available.");
        }
        Token permit = token.get();
        try {
            runnable.run();
            permit.success();
        }
        catch (IgnoreTaskException e) {
            permit.ignore();
            e.handle();
        }
        catch (Exception e) {
            permit.dropped();
            throw e;
        }
    }

    default public Optional<Token> tryAcquire() {
        return this.tryAcquire(true);
    }

    public Optional<Token> tryAcquire(boolean var1);

    public static interface Token {
        public void dropped();

        public void ignore();

        public void success();
    }
}

