/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class CallDataSizeOperation
extends AbstractFixedCostOperation {
    public CallDataSizeOperation(GasCalculator gasCalculator) {
        super(54, "CALLDATASIZE", 0, 1, gasCalculator, gasCalculator.getBaseTierGasCost());
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        Bytes callData = frame.getInputData();
        frame.pushStackItem(Words.intBytes(callData.size()));
        return this.successResponse;
    }
}

