/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.gascalculator;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.LondonGasCalculator;
import org.hyperledger.besu.evm.internal.Words;

public class ShanghaiGasCalculator
extends LondonGasCalculator {
    private static final long INIT_CODE_COST = 2L;

    protected ShanghaiGasCalculator(int maxPrecompile) {
        super(maxPrecompile);
    }

    public ShanghaiGasCalculator() {
    }

    @Override
    public long transactionIntrinsicGasCost(Bytes payload, boolean isContractCreation) {
        long intrinsicGasCost = super.transactionIntrinsicGasCost(payload, isContractCreation);
        if (isContractCreation) {
            return Words.clampedAdd(intrinsicGasCost, ShanghaiGasCalculator.calculateInitGasCost(payload.size()));
        }
        return intrinsicGasCost;
    }

    @Override
    public long createOperationGasCost(MessageFrame frame) {
        long initCodeLength = Words.clampedToLong(frame.getStackItem(2));
        return Words.clampedAdd(super.createOperationGasCost(frame), ShanghaiGasCalculator.calculateInitGasCost(initCodeLength));
    }

    private static long calculateInitGasCost(long initCodeLength) {
        int dataLength = (int)Math.ceil((double)initCodeLength / 32.0);
        return (long)dataLength * 2L;
    }
}

